#include <Arduino.h>
#include <Adafruit_NeoPixel.h>
#include <DHT12.h>
#include <Wire.h>
#include <DS3231.h>
#include <NTPClient.h>
#include <ESP8266WiFi.h>
#include <WiFiUdp.h>

const char *ssid     = "KLIMA";
const char *password = "Klima503767238";

const long utcOffsetInSeconds = 3600;


// Define NTP Client to get time
WiFiUDP ntpUDP;
NTPClient timeClient(ntpUDP, "ntp.task.gda.pl", utcOffsetInSeconds);


#define PIN D3
#define NUMPIXELS 58
Adafruit_NeoPixel pixels = Adafruit_NeoPixel(NUMPIXELS, PIN, NEO_GRB + NEO_KHZ800);
#define DELAYVAL 500

DS3231 zegar;
RTCDateTime dt;
int segment_a,segment_b,segment_c,segment_d;
int lred = 0;
int lgreen = 0;
int lblue = 0;
int zmienna_test = 0;
int ntp_minuta;
int ntp_godzina;
int ntp_sekunda;
int godzina;
int minuta;
int temperatura_wew;
int temperatura_zew = 16;
int tryb;
int przewijanie;
int tik;

// Set dht12 i2c comunication on default Wire pin
DHT12 dht12;

void setup()
{
        Serial.begin(9600);
        pixels.begin(); // Inicjalizacja biblioteki
        pixels.clear(); //czyszczenie lancucha
        Serial.print("kupa ");
        //wlaczenie WiFi
        WiFi.begin(ssid, password);
          while ( WiFi.status() != WL_CONNECTED ) {
            delay ( 500 );
            Serial.print ( "." );
            pixels.setPixelColor(36, 100, 0,0); //LED# , r , g  , b
            pixels.setPixelColor(37, 100, 0,0); //LED# , r , g  , b
            pixels.setPixelColor(20, 100, 0,0); //LED# , r , g  , b
            pixels.setPixelColor(21, 100, 0,0); //LED# , r , g  , b
          }
          Serial.println("IP address: ");
          Serial.println(WiFi.localIP());   //You can get IP address assigned to ESP
          //wlaczenie klienta npt
          timeClient.begin();
//setup i2c
Wire.begin(10, 9); //SDA, SCL = GPIO 10, GPIO 9 (at node mcu is SD3 / SD2)
// Start sensor handshake
        dht12.begin();
zegar.begin();
// Ustawiany date i godzine kompilacji szkicu
zegar.setDateTime(__DATE__, __TIME__);

}
int timeSinceLastRead = 0;

void loop()
{
//pobranie czasu po NTP
 timeClient.update();
 ntp_godzina = timeClient.getHours();
 ntp_minuta = timeClient.getMinutes();
 ntp_sekunda = timeClient.getSeconds();

// Report every 2 seconds.
        if(timeSinceLastRead > 2000) {
// Reading temperature or humidity takes about 250 milliseconds!
// Read temperature as Celsius (the default)
                float t12 = dht12.readTemperature();
                temperatura_wew = int(t12);
// Read temperature as Fahrenheit (isFahrenheit = true)
                float f12 = dht12.readTemperature(true);
// Sensor readings may also be up to 2 seconds 'old' (its a very slow sensor)
                float h12 = dht12.readHumidity();

                bool dht12Read = true;
// Check if any reads failed and exit early (to try again).
                if (isnan(h12) || isnan(t12) || isnan(f12)) {
                        Serial.println("Failed to read from DHT12 sensor!");

                        dht12Read = false;
                }

                if (dht12Read) {
// Compute heat index in Fahrenheit (the default)
                        float hif12 = dht12.computeHeatIndex(f12, h12);
// Compute heat index in Celsius (isFahreheit = false)
                        float hic12 = dht12.computeHeatIndex(t12, h12, false);
// Compute dew point in Fahrenheit (the default)
                        float dpf12 = dht12.dewPoint(f12, h12);
// Compute dew point in Celsius (isFahreheit = false)
                        float dpc12 = dht12.dewPoint(t12, h12, false);

                        Serial.print("DHT12=> Humidity: ");
                        Serial.print(h12);
                        Serial.print(" %\t");/* error message */
                        Serial.print("Temperature: ");
                        Serial.print(t12);
                        Serial.print(" *C ");
                        Serial.print(f12);
                        Serial.print(" *F\t");
                        Serial.print(" Heat index: ");
                        Serial.print(hic12);
                        Serial.print(" *C ");
                        Serial.print(hif12);
                        Serial.print(" *F");
                        Serial.print(" Dew point: ");
                        Serial.print(dpc12);
                        Serial.print(" *C ");
                        Serial.print(dpf12);
                        Serial.println(" *F");
                        Serial.print("zmienna: ");
                        Serial.print(temperatura_zew);
                        Serial.println(ntp_godzina);
                        Serial.println(ntp_minuta);
                        Serial.println(ntp_sekunda);
                }
                timeSinceLastRead = 0;
        }
        delay(100);
        timeSinceLastRead += 100;

// Odczytujemy i wyswietlamy czas
dt = zegar.getDateTime();

        Serial.print("Raw data: ");
  Serial.print(dt.year);   Serial.print("-");
  Serial.print(dt.month);  Serial.print("-");
  Serial.print(dt.day);    Serial.print(" ");
  Serial.print(dt.hour);   Serial.print(":");
  Serial.print(dt.minute); Serial.print(":");
  Serial.print(dt.second); Serial.println("");

        przewijanie = przewijanie + 1;
        if (przewijanie == 15) {
                przewijanie = 0;
        }

        if (przewijanie <=5  ) {
                tryb = 0;
        }
        if (przewijanie == 5) {
                tryb = 1;
        }
        if (przewijanie == 10) {
                tryb = 2;
        }

//jakis tam licznik - do testow
        zmienna_test = zmienna_test + 1;
        if (zmienna_test == 60) {
                zmienna_test = 0;
        }




//tryb wyswietlania - zegar
        if (tryb == 0) {//zegar
                lred = 0; lgreen = 2; lblue=0;
                segment_a = godzina / 10;
                segment_b = godzina % 10;
                segment_c = minuta / 10;
                segment_d = minuta % 10;
                tik = tik + 1;
                if (tik > 1) {
                        tik = 0;
                }
                if (tik == 0) {
                        //rozdzielnik
                        pixels.setPixelColor(28, 0, 0,0); //LED# , r , g  , b
                        pixels.setPixelColor(29, 0, 0,0); //LED# , r , g  , b
                }
                if (tik == 1) {
                        //rozdzielnik
                        pixels.setPixelColor(28, 5, 0,0); //LED# , r , g  , b
                        pixels.setPixelColor(29, 5, 0,0); //LED# , r , g  , b
                }
        }//zegar koniec

//tryb wyswietlania - temperatura wewneczna
        if (tryb == 1) {//temperatura
                lred = 2; lgreen = 2; lblue=0;
                segment_a = temperatura_wew / 10;
                segment_b = temperatura_wew % 10;
                segment_c = 11;
                segment_d = 11;

                //rozdzielnik
                pixels.setPixelColor(28, 0, 0,0); //LED# , r , g  , b
                pixels.setPixelColor(29, 0, 0,0); //LED# , r , g  , b

        }//temperatura koniec


//tryb wyswietlania - temperatura zewneczna
        if (tryb == 2) {//temperatura_zew
                lred = 2; lgreen = 2; lblue=2;
                if (temperatura_zew <= 0) {
                        if (temperatura_zew < 0) {
                                if (temperatura_zew <= 0 and temperatura_zew  >= -9) {
                                        segment_a = 11;
                                        segment_b = temperatura_zew * -1;
                                        segment_c = 11;
                                        segment_d = 11;
                                }
                                if (temperatura_zew < -9) {
                                        segment_a = 10;
                                        segment_b = 11;
                                        segment_c =  (temperatura_zew / 10) * -1;
                                        segment_d =  (temperatura_zew % 10) * -1;
                                }
                        }
                }
                if (temperatura_zew == 0 ) {
                        segment_a = 10;
                        segment_b = 0;
                        segment_c = 11;
                        segment_d = 11;
                }
                if (temperatura_zew > 0 and temperatura_zew < 10 ) {
                        segment_a = 10;
                        segment_b = temperatura_zew;
                        segment_c = 11;
                        segment_d = 11;
                }
                if (temperatura_zew > 9 ) {
                        segment_a = temperatura_zew / 10;
                        segment_b = temperatura_zew % 10;
                        segment_c = 11;
                        segment_d = 11;
                }
                //rozdzielnik
                pixels.setPixelColor(28, 0, 0,0); //LED# , r , g  , b
                pixels.setPixelColor(29, 0, 0,0); //LED# , r , g  , b

        }//temperatura koniec


        // segment A
        if (segment_a == 0) { // 0
                pixels.setPixelColor(0, lred, lgreen,lblue); //LED# , r , g  , b
                pixels.setPixelColor(1, lred, lgreen,lblue); //LED# , r , g  , b

                pixels.setPixelColor(2, lred, lgreen,lblue); //LED# , r , g  , b
                pixels.setPixelColor(3, lred, lgreen,lblue); //LED# , r , g  , b

                pixels.setPixelColor(4, lred, lgreen,lblue); //LED# , r , g  , b
                pixels.setPixelColor(5, lred, lgreen,lblue); //LED# , r , g  , b

                pixels.setPixelColor(6, 0, 0,0); //LED# , r , g  , b
                pixels.setPixelColor(7, 0, 0,0); //LED# , r , g  , b

                pixels.setPixelColor(8, lred, lgreen,lblue); //LED# , r , g  , b
                pixels.setPixelColor(9, lred, lgreen,lblue); //LED# , r , g  , b

                pixels.setPixelColor(10, lred, lgreen,lblue); //LED# , r , g  , b
                pixels.setPixelColor(11, lred, lgreen,lblue); //LED# , r , g  , b

                pixels.setPixelColor(12, lred, lgreen,lblue); //LED# , r , g  , b
                pixels.setPixelColor(13, lred, lgreen,lblue); //LED# , r , g  , b
        }

        if (segment_a == 1) { // 1
                pixels.setPixelColor(0, 0, 0,0); //LED# , r , g  , b
                pixels.setPixelColor(1, 0, 0,0); //LED# , r , g  , b

                pixels.setPixelColor(2, 0, 0,0); //LED# , r , g  , b
                pixels.setPixelColor(3, 0, 0,0); //LED# , r , g  , b

                pixels.setPixelColor(4, lred, lgreen,lblue); //LED# , r , g  , b
                pixels.setPixelColor(5, lred, lgreen,lblue); //LED# , r , g  , b

                pixels.setPixelColor(6, 0, 0,0); //LED# , r , g  , b
                pixels.setPixelColor(7, 0, 0,0); //LED# , r , g  , b

                pixels.setPixelColor(8, 0, 0,0); //LED# , r , g  , b
                pixels.setPixelColor(9, 0, 0,0); //LED# , r , g  , b

                pixels.setPixelColor(10, 0, 0,0); //LED# , r , g  , b
                pixels.setPixelColor(11, 0, 0,0); //LED# , r , g  , b

                pixels.setPixelColor(12, lred, lgreen,lblue); //LED# , r , g  , b
                pixels.setPixelColor(13, lred, lgreen,lblue); //LED# , r , g  , b
        }

        if (segment_a == 2) { // 2
                pixels.setPixelColor(0, 0, 0,0); //LED# , r , g  , b
                pixels.setPixelColor(1, 0, 0,0); //LED# , r , g  , b

                pixels.setPixelColor(2, lred, lgreen,lblue); //LED# , r , g  , b
                pixels.setPixelColor(3, lred, lgreen,lblue); //LED# , r , g  , b

                pixels.setPixelColor(4, lred, lgreen,lblue); //LED# , r , g  , b
                pixels.setPixelColor(5, lred, lgreen,lblue); //LED# , r , g  , b

                pixels.setPixelColor(6, lred, lgreen,lblue); //LED# , r , g  , b
                pixels.setPixelColor(7, lred, lgreen,lblue); //LED# , r , g  , b

                pixels.setPixelColor(8, lred, lgreen,lblue); //LED# , r , g  , b
                pixels.setPixelColor(9, lred, lgreen,lblue); //LED# , r , g  , b

                pixels.setPixelColor(10, lred, lgreen,lblue); //LED# , r , g  , b
                pixels.setPixelColor(11, lred, lgreen,lblue); //LED# , r , g  , b

                pixels.setPixelColor(12, 0, 0,0); //LED# , r , g  , b
                pixels.setPixelColor(13, 0, 0,0); //LED# , r , g  , b
        }

        if (segment_a == 3) { // 3
                pixels.setPixelColor(0, 0, 0,0); //LED# , r , g  , b
                pixels.setPixelColor(1, 0, 0,0); //LED# , r , g  , b

                pixels.setPixelColor(2, lred, lgreen,lblue); //LED# , r , g  , b
                pixels.setPixelColor(3, lred, lgreen,lblue); //LED# , r , g  , b

                pixels.setPixelColor(4, lred, lgreen,lblue); //LED# , r , g  , b
                pixels.setPixelColor(5, lred, lgreen,lblue); //LED# , r , g  , b

                pixels.setPixelColor(6, lred, lgreen,lblue); //LED# , r , g  , b
                pixels.setPixelColor(7, lred, lgreen,lblue); //LED# , r , g  , b

                pixels.setPixelColor(8, 0, 0,0); //LED# , r , g  , b
                pixels.setPixelColor(9, 0, 0,0); //LED# , r , g  , b

                pixels.setPixelColor(10, lred, lgreen,lblue); //LED# , r , g  , b
                pixels.setPixelColor(11, lred, lgreen,lblue); //LED# , r , g  , b

                pixels.setPixelColor(12, lred, lgreen,lblue); //LED# , r , g  , b
                pixels.setPixelColor(13, lred, lgreen,lblue); //LED# , r , g  , b
        }

        if (segment_a == 4) { // 4
                pixels.setPixelColor(0, lred, lgreen,lblue); //LED# , r , g  , b
                pixels.setPixelColor(1, lred, lgreen,lblue); //LED# , r , g  , b

                pixels.setPixelColor(2, 0, 0,0); //LED# , r , g  , b
                pixels.setPixelColor(3, 0, 0,0); //LED# , r , g  , b

                pixels.setPixelColor(4, lred, lgreen,lblue); //LED# , r , g  , b
                pixels.setPixelColor(5, lred, lgreen,lblue); //LED# , r , g  , b

                pixels.setPixelColor(6, lred, lgreen,lblue); //LED# , r , g  , b
                pixels.setPixelColor(7, lred, lgreen,lblue); //LED# , r , g  , b

                pixels.setPixelColor(8, 0, 0,0); //LED# , r , g  , b
                pixels.setPixelColor(9, 0, 0,0); //LED# , r , g  , b

                pixels.setPixelColor(10,  0, 0,0);//LED# , r , g  , b
                pixels.setPixelColor(11,  0, 0,0);//LED# , r , g  , b

                pixels.setPixelColor(12, lred, lgreen,lblue); //LED# , r , g  , b
                pixels.setPixelColor(13, lred, lgreen,lblue); //LED# , r , g  , b
        }

        if (segment_a == 5) { // 5
                pixels.setPixelColor(0, lred, lgreen,lblue); //LED# , r , g  , b
                pixels.setPixelColor(1, lred, lgreen,lblue); //LED# , r , g  , b

                pixels.setPixelColor(2, lred, lgreen,lblue); //LED# , r , g  , b
                pixels.setPixelColor(3, lred, lgreen,lblue); //LED# , r , g  , b

                pixels.setPixelColor(4, 0, 0,0); //LED# , r , g  , b
                pixels.setPixelColor(5, 0, 0,0); //LED# , r , g  , b

                pixels.setPixelColor(6, lred, lgreen,lblue); //LED# , r , g  , b
                pixels.setPixelColor(7, lred, lgreen,lblue); //LED# , r , g  , b

                pixels.setPixelColor(8, 0, 0,0); //LED# , r , g  , b
                pixels.setPixelColor(9, 0, 0,0); //LED# , r , g  , b

                pixels.setPixelColor(10,  lred, lgreen,lblue);//LED# , r , g  , b
                pixels.setPixelColor(11,  lred, lgreen,lblue);//LED# , r , g  , b

                pixels.setPixelColor(12, lred, lgreen,lblue); //LED# , r , g  , b
                pixels.setPixelColor(13, lred, lgreen,lblue); //LED# , r , g  , b
        }

        if (segment_a == 6) { // 6
                pixels.setPixelColor(0, lred, lgreen,lblue); //LED# , r , g  , b
                pixels.setPixelColor(1, lred, lgreen,lblue); //LED# , r , g  , b

                pixels.setPixelColor(2, lred, lgreen,lblue); //LED# , r , g  , b
                pixels.setPixelColor(3, lred, lgreen,lblue); //LED# , r , g  , b

                pixels.setPixelColor(4, 0, 0,0); //LED# , r , g  , b
                pixels.setPixelColor(5, 0, 0,0); //LED# , r , g  , b

                pixels.setPixelColor(6, lred, lgreen,lblue); //LED# , r , g  , b
                pixels.setPixelColor(7, lred, lgreen,lblue); //LED# , r , g  , b

                pixels.setPixelColor(8, lred, lgreen,lblue); //LED# , r , g  , b
                pixels.setPixelColor(9, lred, lgreen,lblue); //LED# , r , g  , b

                pixels.setPixelColor(10, lred, lgreen,lblue); //LED# , r , g  , b
                pixels.setPixelColor(11, lred, lgreen,lblue); //LED# , r , g  , b

                pixels.setPixelColor(12, lred, lgreen,lblue); //LED# , r , g  , b
                pixels.setPixelColor(13, lred, lgreen,lblue); //LED# , r , g  , b
        }

        if (segment_a == 7) { // 7
                pixels.setPixelColor(0, 0, 0,0); //LED# , r , g  , b
                pixels.setPixelColor(1, 0, 0,0); //LED# , r , g  , b

                pixels.setPixelColor(2, lred, lgreen,lblue); //LED# , r , g  , b
                pixels.setPixelColor(3, lred, lgreen,lblue); //LED# , r , g  , b

                pixels.setPixelColor(4, lred, lgreen,lblue); //LED# , r , g  , b
                pixels.setPixelColor(5, lred, lgreen,lblue); //LED# , r , g  , b

                pixels.setPixelColor(6, 0, 0,0); //LED# , r , g  , b
                pixels.setPixelColor(7, 0, 0,0); //LED# , r , g  , b

                pixels.setPixelColor(8, 0, 0,0); //LED# , r , g  , b
                pixels.setPixelColor(9, 0, 0,0); //LED# , r , g  , b

                pixels.setPixelColor(10, 0, 0,0); //LED# , r , g  , b
                pixels.setPixelColor(11, 0, 0,0); //LED# , r , g  , b

                pixels.setPixelColor(12, lred, lgreen,lblue); //LED# , r , g  , b
                pixels.setPixelColor(13, lred, lgreen,lblue); //LED# , r , g  , b
        }

        if (segment_a == 8) { // 8
                pixels.setPixelColor(0, lred, lgreen,lblue); //LED# , r , g  , b
                pixels.setPixelColor(1, lred, lgreen,lblue); //LED# , r , g  , b

                pixels.setPixelColor(2, lred, lgreen,lblue); //LED# , r , g  , b
                pixels.setPixelColor(3, lred, lgreen,lblue); //LED# , r , g  , b

                pixels.setPixelColor(4, lred, lgreen,lblue); //LED# , r , g  , b
                pixels.setPixelColor(5, lred, lgreen,lblue); //LED# , r , g  , b

                pixels.setPixelColor(6, lred, lgreen,lblue); //LED# , r , g  , b
                pixels.setPixelColor(7, lred, lgreen,lblue); //LED# , r , g  , b

                pixels.setPixelColor(8, lred, lgreen,lblue); //LED# , r , g  , b
                pixels.setPixelColor(9, lred, lgreen,lblue); //LED# , r , g  , b

                pixels.setPixelColor(10, lred, lgreen,lblue); //LED# , r , g  , b
                pixels.setPixelColor(11, lred, lgreen,lblue); //LED# , r , g  , b

                pixels.setPixelColor(12, lred, lgreen,lblue); //LED# , r , g  , b
                pixels.setPixelColor(13, lred, lgreen,lblue); //LED# , r , g  , b
        }

        if (segment_a == 9) { // 9
                pixels.setPixelColor(0, lred, lgreen,lblue); //LED# , r , g  , b
                pixels.setPixelColor(1, lred, lgreen,lblue); //LED# , r , g  , b

                pixels.setPixelColor(2, lred, lgreen,lblue); //LED# , r , g  , b
                pixels.setPixelColor(3, lred, lgreen,lblue); //LED# , r , g  , b

                pixels.setPixelColor(4, lred, lgreen,lblue); //LED# , r , g  , b
                pixels.setPixelColor(5, lred, lgreen,lblue); //LED# , r , g  , b

                pixels.setPixelColor(6, lred, lgreen,lblue); //LED# , r , g  , b
                pixels.setPixelColor(7, lred, lgreen,lblue); //LED# , r , g  , b

                pixels.setPixelColor(8, 0, 0,0); //LED# , r , g  , b
                pixels.setPixelColor(9, 0, 0,0); //LED# , r , g  , b

                pixels.setPixelColor(10, lred, lgreen,lblue); //LED# , r , g  , b
                pixels.setPixelColor(11, lred, lgreen,lblue); //LED# , r , g  , b

                pixels.setPixelColor(12, lred, lgreen,lblue); //LED# , r , g  , b
                pixels.setPixelColor(13, lred, lgreen,lblue); //LED# , r , g  , b
        }

        if (segment_a == 10) { // 10
                pixels.setPixelColor(0,  0, 0,0);//LED# , r , g  , b
                pixels.setPixelColor(1,  0, 0,0);//LED# , r , g  , b

                pixels.setPixelColor(2,  0, 0,0);//LED# , r , g  , b
                pixels.setPixelColor(3,  0, 0,0);//LED# , r , g  , b

                pixels.setPixelColor(4,  0, 0,0);//LED# , r , g  , b
                pixels.setPixelColor(5,  0, 0,0);//LED# , r , g  , b

                pixels.setPixelColor(6,  0, 0,0);//LED# , r , g  , b
                pixels.setPixelColor(7,  0, 0,0);//LED# , r , g  , b

                pixels.setPixelColor(8, 0, 0,0); //LED# , r , g  , b
                pixels.setPixelColor(9, 0, 0,0); //LED# , r , g  , b

                pixels.setPixelColor(10,  0, 0,0);//LED# , r , g  , b
                pixels.setPixelColor(11,  0, 0,0);//LED# , r , g  , b

                pixels.setPixelColor(12,  0, 0,0);//LED# , r , g  , b
                pixels.setPixelColor(13,  0, 0,0);//LED# , r , g  , b
        }
        if (segment_a == 11) { // 10
                pixels.setPixelColor(0,  0, 0,0);//LED# , r , g  , b
                pixels.setPixelColor(1,  0, 0,0);//LED# , r , g  , b

                pixels.setPixelColor(2,  0, 0,0);//LED# , r , g  , b
                pixels.setPixelColor(3,  0, 0,0);//LED# , r , g  , b

                pixels.setPixelColor(4,  0, 0,0);//LED# , r , g  , b
                pixels.setPixelColor(5,  0, 0,0);//LED# , r , g  , b

                pixels.setPixelColor(6,  0, 0,5);//LED# , r , g  , b
                pixels.setPixelColor(7,  0, 0,5);//LED# , r , g  , b

                pixels.setPixelColor(8, 0, 0,0); //LED# , r , g  , b
                pixels.setPixelColor(9, 0, 0,0); //LED# , r , g  , b

                pixels.setPixelColor(10,  0, 0,0);//LED# , r , g  , b
                pixels.setPixelColor(11,  0, 0,0);//LED# , r , g  , b

                pixels.setPixelColor(12,  0, 0,0);//LED# , r , g  , b
                pixels.setPixelColor(13,  0, 0,0);//LED# , r , g  , b
        }

//segment b
        if (segment_b == 0) { // 0
                pixels.setPixelColor(14, lred, lgreen,lblue); //LED# , r , g  , b
                pixels.setPixelColor(15, lred, lgreen,lblue); //LED# , r , g  , b

                pixels.setPixelColor(16, lred, lgreen,lblue); //LED# , r , g  , b
                pixels.setPixelColor(17, lred, lgreen,lblue); //LED# , r , g  , b

                pixels.setPixelColor(18, lred, lgreen,lblue); //LED# , r , g  , b
                pixels.setPixelColor(19, lred, lgreen,lblue); //LED# , r , g  , b

                pixels.setPixelColor(20, 0, 0,0); //LED# , r , g  , b
                pixels.setPixelColor(21, 0, 0,0); //LED# , r , g  , b

                pixels.setPixelColor(22, lred, lgreen,lblue); //LED# , r , g  , b
                pixels.setPixelColor(23, lred, lgreen,lblue); //LED# , r , g  , b

                pixels.setPixelColor(24, lred, lgreen,lblue); //LED# , r , g  , b
                pixels.setPixelColor(25, lred, lgreen,lblue); //LED# , r , g  , b

                pixels.setPixelColor(26, lred, lgreen,lblue); //LED# , r , g  , b
                pixels.setPixelColor(27, lred, lgreen,lblue); //LED# , r (27,, g  , b
        }

        if (segment_b == 1) { // 1
                pixels.setPixelColor(14, 0, 0,0); //LED# , r , g  , b
                pixels.setPixelColor(15, 0, 0,0); //LED# , r , g  , b

                pixels.setPixelColor(16, 0, 0,0); //LED# , r , g  , b
                pixels.setPixelColor(17, 0, 0,0); //LED# , r , g  , b

                pixels.setPixelColor(18, lred, lgreen,lblue); //LED# , r , g  , b
                pixels.setPixelColor(19, lred, lgreen,lblue); //LED# , r , g  , b

                pixels.setPixelColor(20, 0, 0,0); //LED# , r , g  , b
                pixels.setPixelColor(21, 0, 0,0); //LED# , r , g  , b

                pixels.setPixelColor(22, 0, 0,0); //LED# , r , g  , b
                pixels.setPixelColor(23, 0, 0,0); //LED# , r , g  , b

                pixels.setPixelColor(24, 0, 0,0); //LED# , r , g  , b
                pixels.setPixelColor(25, 0, 0,0); //LED# , r , g  , b

                pixels.setPixelColor(26, lred, lgreen,lblue); //LED# , r , g  , b
                pixels.setPixelColor(27, lred, lgreen,lblue); //LED# , r , g  , b
        }

        if (segment_b == 2) { // 2
                pixels.setPixelColor(14, 0, 0,0); //LED# , r , g  , b
                pixels.setPixelColor(15, 0, 0,0); //LED# , r , g  , b

                pixels.setPixelColor(16, lred, lgreen,lblue); //LED# , r , g  , b
                pixels.setPixelColor(17, lred, lgreen,lblue); //LED# , r , g  , b

                pixels.setPixelColor(18, lred, lgreen,lblue); //LED# , r , g  , b
                pixels.setPixelColor(19, lred, lgreen,lblue); //LED# , r , g  , b

                pixels.setPixelColor(20, lred, lgreen,lblue); //LED# , r , g  , b
                pixels.setPixelColor(21, lred, lgreen,lblue); //LED# , r , g  , b

                pixels.setPixelColor(22, lred, lgreen,lblue); //LED# , r , g  , b
                pixels.setPixelColor(23, lred, lgreen,lblue); //LED# , r , g  , b

                pixels.setPixelColor(24, lred, lgreen,lblue); //LED# , r , g  , b
                pixels.setPixelColor(25, lred, lgreen,lblue); //LED# , r , g  , b

                pixels.setPixelColor(26, 0, 0,0); //LED# , r , g  , b
                pixels.setPixelColor(27, 0, 0,0); //LED# , r , g  , b
        }

        if (segment_b == 3) { // 3
                pixels.setPixelColor(14, 0, 0,0); //LED# , r , g  , b
                pixels.setPixelColor(15, 0, 0,0); //LED# , r , g  , b

                pixels.setPixelColor(16, lred, lgreen,lblue); //LED# , r , g  , b
                pixels.setPixelColor(17, lred, lgreen,lblue); //LED# , r , g  , b

                pixels.setPixelColor(18, lred, lgreen,lblue); //LED# , r , g  , b
                pixels.setPixelColor(19, lred, lgreen,lblue); //LED# , r , g  , b

                pixels.setPixelColor(20, lred, lgreen,lblue); //LED# , r , g  , b
                pixels.setPixelColor(21, lred, lgreen,lblue); //LED# , r , g  , b

                pixels.setPixelColor(22, 0, 0,0); //LED# , r , g  , b
                pixels.setPixelColor(23, 0, 0,0); //LED# , r , g  , b

                pixels.setPixelColor(24, lred, lgreen,lblue); //LED# , r , g  , b
                pixels.setPixelColor(25, lred, lgreen,lblue); //LED# , r , g  , b

                pixels.setPixelColor(26, lred, lgreen,lblue); //LED# , r , g  , b
                pixels.setPixelColor(27, lred, lgreen,lblue); //LED# , r , g  , b
        }

        if (segment_b == 4) { // 4
                pixels.setPixelColor(14, lred, lgreen,lblue); //LED# , r , g  , b
                pixels.setPixelColor(15, lred, lgreen,lblue); //LED# , r , g  , b

                pixels.setPixelColor(16, 0, 0,0); //LED# , r , g  , b
                pixels.setPixelColor(17, 0, 0,0); //LED# , r , g  , b

                pixels.setPixelColor(18, lred, lgreen,lblue); //LED# , r , g  , b
                pixels.setPixelColor(19, lred, lgreen,lblue); //LED# , r , g  , b

                pixels.setPixelColor(20, lred, lgreen,lblue); //LED# , r , g  , b
                pixels.setPixelColor(21, lred, lgreen,lblue); //LED# , r , g  , b

                pixels.setPixelColor(22, 0, 0,0); //LED# , r , g  , b
                pixels.setPixelColor(23, 0, 0,0); //LED# , r , g  , b

                pixels.setPixelColor(24,  0, 0,0);//LED# , r , g  , b
                pixels.setPixelColor(25,  0, 0,0);//LED# , r , g  , b

                pixels.setPixelColor(26, lred, lgreen,lblue); //LED# , r , g  , b
                pixels.setPixelColor(27, lred, lgreen,lblue); //LED# , r , g  , b
        }

        if (segment_b == 5) { // 5
                pixels.setPixelColor(14, lred, lgreen,lblue); //LED# , r , g  , b
                pixels.setPixelColor(15, lred, lgreen,lblue); //LED# , r , g  , b

                pixels.setPixelColor(16, lred, lgreen,lblue); //LED# , r , g  , b
                pixels.setPixelColor(17, lred, lgreen,lblue); //LED# , r , g  , b

                pixels.setPixelColor(18, 0, 0,0); //LED# , r , g  , b
                pixels.setPixelColor(19, 0, 0,0); //LED# , r , g  , b

                pixels.setPixelColor(20, lred, lgreen,lblue); //LED# , r , g  , b
                pixels.setPixelColor(21, lred, lgreen,lblue); //LED# , r , g  , b

                pixels.setPixelColor(22, 0, 0,0); //LED# , r , g  , b
                pixels.setPixelColor(23, 0, 0,0); //LED# , r , g  , b

                pixels.setPixelColor(24,  lred, lgreen,lblue);//LED# , r , g  , b
                pixels.setPixelColor(25,  lred, lgreen,lblue);//LED# , r , g  , b

                pixels.setPixelColor(26, lred, lgreen,lblue); //LED# , r , g  , b
                pixels.setPixelColor(27, lred, lgreen,lblue); //LED# , r , g  , b
        }

        if (segment_b == 6) { // 6
                pixels.setPixelColor(14, lred, lgreen,lblue); //LED# , r , g  , b
                pixels.setPixelColor(15, lred, lgreen,lblue); //LED# , r , g  , b

                pixels.setPixelColor(16, lred, lgreen,lblue); //LED# , r , g  , b
                pixels.setPixelColor(17, lred, lgreen,lblue); //LED# , r , g  , b

                pixels.setPixelColor(18, 0, 0,0); //LED# , r , g  , b
                pixels.setPixelColor(19, 0, 0,0); //LED# , r , g  , b

                pixels.setPixelColor(20, lred, lgreen,lblue); //LED# , r , g  , b
                pixels.setPixelColor(21, lred, lgreen,lblue); //LED# , r , g  , b

                pixels.setPixelColor(22, lred, lgreen,lblue); //LED# , r , g  , b
                pixels.setPixelColor(23, lred, lgreen,lblue); //LED# , r , g  , b

                pixels.setPixelColor(24, lred, lgreen,lblue); //LED# , r , g  , b
                pixels.setPixelColor(25, lred, lgreen,lblue); //LED# , r , g  , b

                pixels.setPixelColor(26, lred, lgreen,lblue); //LED# , r , g  , b
                pixels.setPixelColor(27, lred, lgreen,lblue); //LED# , r , g  , b
        }

        if (segment_b == 7) { // 7
                pixels.setPixelColor(14, 0, 0,0); //LED# , r , g  , b
                pixels.setPixelColor(15, 0, 0,0); //LED# , r , g  , b

                pixels.setPixelColor(16, lred, lgreen,lblue); //LED# , r , g  , b
                pixels.setPixelColor(17, lred, lgreen,lblue); //LED# , r , g  , b

                pixels.setPixelColor(18, lred, lgreen,lblue); //LED# , r , g  , b
                pixels.setPixelColor(19, lred, lgreen,lblue); //LED# , r , g  , b

                pixels.setPixelColor(20, 0, 0,0); //LED# , r , g  , b
                pixels.setPixelColor(21, 0, 0,0); //LED# , r , g  , b

                pixels.setPixelColor(22, 0, 0,0); //LED# , r , g  , b
                pixels.setPixelColor(23, 0, 0,0); //LED# , r , g  , b

                pixels.setPixelColor(24, 0, 0,0); //LED# , r , g  , b
                pixels.setPixelColor(25, 0, 0,0); //LED# , r , g  , b

                pixels.setPixelColor(26, lred, lgreen,lblue); //LED# , r , g  , b
                pixels.setPixelColor(27, lred, lgreen,lblue); //LED# , r , g  , b
        }

        if (segment_b == 8) { // 8
                pixels.setPixelColor(14, lred, lgreen,lblue); //LED# , r , g  , b
                pixels.setPixelColor(15, lred, lgreen,lblue); //LED# , r , g  , b

                pixels.setPixelColor(16, lred, lgreen,lblue); //LED# , r , g  , b
                pixels.setPixelColor(17, lred, lgreen,lblue); //LED# , r , g  , b

                pixels.setPixelColor(18, lred, lgreen,lblue); //LED# , r , g  , b
                pixels.setPixelColor(19, lred, lgreen,lblue); //LED# , r , g  , b

                pixels.setPixelColor(20, lred, lgreen,lblue); //LED# , r , g  , b
                pixels.setPixelColor(21, lred, lgreen,lblue); //LED# , r , g  , b

                pixels.setPixelColor(22, lred, lgreen,lblue); //LED# , r , g  , b
                pixels.setPixelColor(23, lred, lgreen,lblue); //LED# , r , g  , b

                pixels.setPixelColor(24, lred, lgreen,lblue); //LED# , r , g  , b
                pixels.setPixelColor(25, lred, lgreen,lblue); //LED# , r , g  , b

                pixels.setPixelColor(26, lred, lgreen,lblue); //LED# , r , g  , b
                pixels.setPixelColor(27, lred, lgreen,lblue); //LED# , r , g  , b
        }

        if (segment_b == 9) { // 9
                pixels.setPixelColor(14, lred, lgreen,lblue); //LED# , r , g  , b
                pixels.setPixelColor(15, lred, lgreen,lblue); //LED# , r , g  , b

                pixels.setPixelColor(16, lred, lgreen,lblue); //LED# , r , g  , b
                pixels.setPixelColor(17, lred, lgreen,lblue); //LED# , r , g  , b

                pixels.setPixelColor(18, lred, lgreen,lblue); //LED# , r , g  , b
                pixels.setPixelColor(19, lred, lgreen,lblue); //LED# , r , g  , b

                pixels.setPixelColor(20, lred, lgreen,lblue); //LED# , r , g  , b
                pixels.setPixelColor(21, lred, lgreen,lblue); //LED# , r , g  , b

                pixels.setPixelColor(22, 0, 0,0); //LED# , r , g  , b
                pixels.setPixelColor(23, 0, 0,0); //LED# , r , g  , b

                pixels.setPixelColor(24, lred, lgreen,lblue); //LED# , r , g  , b
                pixels.setPixelColor(25, lred, lgreen,lblue); //LED# , r , g  , b

                pixels.setPixelColor(26, lred, lgreen,lblue); //LED# , r , g  , b
                pixels.setPixelColor(27, lred, lgreen,lblue); //LED# , r , g  , b
        }

        if (segment_b == 10) { // 1
                pixels.setPixelColor(14, 0, 0,0); //LED# , r , g  , b
                pixels.setPixelColor(15, 0, 0,0); //LED# , r , g  , b

                pixels.setPixelColor(16, 0, 0,0); //LED# , r , g  , b
                pixels.setPixelColor(17, 0, 0,0); //LED# , r , g  , b

                pixels.setPixelColor(18, 0, 0,0); //LED# , r , g  , b
                pixels.setPixelColor(19, 0, 0,0); //LED# , r , g  , b

                pixels.setPixelColor(20, 0, 0,0); //LED# , r , g  , b
                pixels.setPixelColor(21, 0, 0,0); //LED# , r , g  , b

                pixels.setPixelColor(22, 0, 0,0); //LED# , r , g  , b
                pixels.setPixelColor(23, 0, 0,0); //LED# , r , g  , b

                pixels.setPixelColor(24, 0, 0,0); //LED# , r , g  , b
                pixels.setPixelColor(25, 0, 0,0); //LED# , r , g  , b

                pixels.setPixelColor(26, 0, 0,0); //LED# , r , g  , b
                pixels.setPixelColor(27, 0, 0,0); //LED# , r , g  , b
        }

        if (segment_b == 11) { // minus symbol "-"
                pixels.setPixelColor(14, 0, 0,0); //LED# , r , g  , b
                pixels.setPixelColor(15, 0, 0,0); //LED# , r , g  , b

                pixels.setPixelColor(16, 0, 0,0); //LED# , r , g  , b
                pixels.setPixelColor(17, 0, 0,0); //LED# , r , g  , b

                pixels.setPixelColor(18, 0, 0,0); //LED# , r , g  , b
                pixels.setPixelColor(19, 0, 0,0); //LED# , r , g  , b

                pixels.setPixelColor(20, 0, 0,lblue); //LED# , r , g  , b
                pixels.setPixelColor(21, 0, 0,lblue); //LED# , r , g  , b

                pixels.setPixelColor(22, 0, 0,0); //LED# , r , g  , b
                pixels.setPixelColor(23, 0, 0,0); //LED# , r , g  , b

                pixels.setPixelColor(24, 0, 0,0); //LED# , r , g  , b
                pixels.setPixelColor(25, 0, 0,0); //LED# , r , g  , b

                pixels.setPixelColor(26, 0, 0,0); //LED# , r , g  , b
                pixels.setPixelColor(27, 0, 0,0); //LED# , r , g  , b
        }


//segment c
        if (segment_c == 0) { // 0
                pixels.setPixelColor(30, lred, lgreen,lblue); //LED# , r , g  , b
                pixels.setPixelColor(31, lred, lgreen,lblue); //LED# , r , g  , b

                pixels.setPixelColor(32, lred, lgreen,lblue); //LED# , r , g  , b
                pixels.setPixelColor(33, lred, lgreen,lblue); //LED# , r , g  , b

                pixels.setPixelColor(34, lred, lgreen,lblue); //LED# , r , g  , b
                pixels.setPixelColor(35, lred, lgreen,lblue); //LED# , r , g  , b

                pixels.setPixelColor(36, 0, 0,0); //LED# , r , g  , b
                pixels.setPixelColor(37, 0, 0,0); //LED# , r , g  , b

                pixels.setPixelColor(38, lred, lgreen,lblue); //LED# , r , g  , b
                pixels.setPixelColor(39, lred, lgreen,lblue); //LED# , r , g  , b

                pixels.setPixelColor(40, lred, lgreen,lblue); //LED# , r , g  , b
                pixels.setPixelColor(41, lred, lgreen,lblue); //LED# , r , g  , b

                pixels.setPixelColor(42, lred, lgreen,lblue); //LED# , r , g  , b
                pixels.setPixelColor(43, lred, lgreen,lblue); //LED# , r (43,, g  , b
        }

        if (segment_c == 1) { // 1
                pixels.setPixelColor(30, 0, 0,0); //LED# , r , g  , b
                pixels.setPixelColor(31, 0, 0,0); //LED# , r , g  , b

                pixels.setPixelColor(32, 0, 0,0); //LED# , r , g  , b
                pixels.setPixelColor(33, 0, 0,0); //LED# , r , g  , b

                pixels.setPixelColor(34, lred, lgreen,lblue); //LED# , r , g  , b
                pixels.setPixelColor(35, lred, lgreen,lblue); //LED# , r , g  , b

                pixels.setPixelColor(36, 0, 0,0); //LED# , r , g  , b
                pixels.setPixelColor(37, 0, 0,0); //LED# , r , g  , b

                pixels.setPixelColor(38, 0, 0,0); //LED# , r , g  , b
                pixels.setPixelColor(39, 0, 0,0); //LED# , r , g  , b

                pixels.setPixelColor(40, 0, 0,0); //LED# , r , g  , b
                pixels.setPixelColor(41, 0, 0,0); //LED# , r , g  , b

                pixels.setPixelColor(42, lred, lgreen,lblue); //LED# , r , g  , b
                pixels.setPixelColor(43, lred, lgreen,lblue); //LED# , r , g  , b
        }

        if (segment_c == 2) { // 2
                pixels.setPixelColor(30, 0, 0,0); //LED# , r , g  , b
                pixels.setPixelColor(31, 0, 0,0); //LED# , r , g  , b

                pixels.setPixelColor(32, lred, lgreen,lblue); //LED# , r , g  , b
                pixels.setPixelColor(33, lred, lgreen,lblue); //LED# , r , g  , b

                pixels.setPixelColor(34, lred, lgreen,lblue); //LED# , r , g  , b
                pixels.setPixelColor(35, lred, lgreen,lblue); //LED# , r , g  , b

                pixels.setPixelColor(36, lred, lgreen,lblue); //LED# , r , g  , b
                pixels.setPixelColor(37, lred, lgreen,lblue); //LED# , r , g  , b

                pixels.setPixelColor(38, lred, lgreen,lblue); //LED# , r , g  , b
                pixels.setPixelColor(39, lred, lgreen,lblue); //LED# , r , g  , b

                pixels.setPixelColor(40, lred, lgreen,lblue); //LED# , r , g  , b
                pixels.setPixelColor(41, lred, lgreen,lblue); //LED# , r , g  , b

                pixels.setPixelColor(42, 0, 0,0); //LED# , r , g  , b
                pixels.setPixelColor(43, 0, 0,0); //LED# , r , g  , b
        }

        if (segment_c == 3) { // 3
                pixels.setPixelColor(30, 0, 0,0); //LED# , r , g  , b
                pixels.setPixelColor(31, 0, 0,0); //LED# , r , g  , b

                pixels.setPixelColor(32, lred, lgreen,lblue); //LED# , r , g  , b
                pixels.setPixelColor(33, lred, lgreen,lblue); //LED# , r , g  , b

                pixels.setPixelColor(34, lred, lgreen,lblue); //LED# , r , g  , b
                pixels.setPixelColor(35, lred, lgreen,lblue); //LED# , r , g  , b

                pixels.setPixelColor(36, lred, lgreen,lblue); //LED# , r , g  , b
                pixels.setPixelColor(37, lred, lgreen,lblue); //LED# , r , g  , b

                pixels.setPixelColor(38, 0, 0,0); //LED# , r , g  , b
                pixels.setPixelColor(39, 0, 0,0); //LED# , r , g  , b

                pixels.setPixelColor(40, lred, lgreen,lblue); //LED# , r , g  , b
                pixels.setPixelColor(41, lred, lgreen,lblue); //LED# , r , g  , b

                pixels.setPixelColor(42, lred, lgreen,lblue); //LED# , r , g  , b
                pixels.setPixelColor(43, lred, lgreen,lblue); //LED# , r , g  , b
        }

        if (segment_c == 4) { // 4
                pixels.setPixelColor(30, lred, lgreen,lblue); //LED# , r , g  , b
                pixels.setPixelColor(31, lred, lgreen,lblue); //LED# , r , g  , b

                pixels.setPixelColor(32, 0, 0,0); //LED# , r , g  , b
                pixels.setPixelColor(33, 0, 0,0); //LED# , r , g  , b

                pixels.setPixelColor(34, lred, lgreen,lblue); //LED# , r , g  , b
                pixels.setPixelColor(35, lred, lgreen,lblue); //LED# , r , g  , b

                pixels.setPixelColor(36, lred, lgreen,lblue); //LED# , r , g  , b
                pixels.setPixelColor(37, lred, lgreen,lblue); //LED# , r , g  , b

                pixels.setPixelColor(38, 0, 0,0); //LED# , r , g  , b
                pixels.setPixelColor(39, 0, 0,0); //LED# , r , g  , b

                pixels.setPixelColor(40,  0, 0,0);//LED# , r , g  , b
                pixels.setPixelColor(41,  0, 0,0);//LED# , r , g  , b

                pixels.setPixelColor(42, lred, lgreen,lblue); //LED# , r , g  , b
                pixels.setPixelColor(43, lred, lgreen,lblue); //LED# , r , g  , b
        }

        if (segment_c == 5) { // 5
                pixels.setPixelColor(30, lred, lgreen,lblue); //LED# , r , g  , b
                pixels.setPixelColor(31, lred, lgreen,lblue); //LED# , r , g  , b

                pixels.setPixelColor(32, lred, lgreen,lblue); //LED# , r , g  , b
                pixels.setPixelColor(33, lred, lgreen,lblue); //LED# , r , g  , b

                pixels.setPixelColor(34, 0, 0,0); //LED# , r , g  , b
                pixels.setPixelColor(35, 0, 0,0); //LED# , r , g  , b

                pixels.setPixelColor(36, lred, lgreen,lblue); //LED# , r , g  , b
                pixels.setPixelColor(37, lred, lgreen,lblue); //LED# , r , g  , b

                pixels.setPixelColor(38, 0, 0,0); //LED# , r , g  , b
                pixels.setPixelColor(39, 0, 0,0); //LED# , r , g  , b

                pixels.setPixelColor(40,  lred, lgreen,lblue);//LED# , r , g  , b
                pixels.setPixelColor(41,  lred, lgreen,lblue);//LED# , r , g  , b

                pixels.setPixelColor(42, lred, lgreen,lblue); //LED# , r , g  , b
                pixels.setPixelColor(43, lred, lgreen,lblue); //LED# , r , g  , b
        }

        if (segment_c == 6) { // 6
                pixels.setPixelColor(30, lred, lgreen,lblue); //LED# , r , g  , b
                pixels.setPixelColor(31, lred, lgreen,lblue); //LED# , r , g  , b

                pixels.setPixelColor(32, lred, lgreen,lblue); //LED# , r , g  , b
                pixels.setPixelColor(33, lred, lgreen,lblue); //LED# , r , g  , b

                pixels.setPixelColor(34, 0, 0,0); //LED# , r , g  , b
                pixels.setPixelColor(35, 0, 0,0); //LED# , r , g  , b

                pixels.setPixelColor(36, lred, lgreen,lblue); //LED# , r , g  , b
                pixels.setPixelColor(37, lred, lgreen,lblue); //LED# , r , g  , b

                pixels.setPixelColor(38, lred, lgreen,lblue); //LED# , r , g  , b
                pixels.setPixelColor(39, lred, lgreen,lblue); //LED# , r , g  , b

                pixels.setPixelColor(40, lred, lgreen,lblue); //LED# , r , g  , b
                pixels.setPixelColor(41, lred, lgreen,lblue); //LED# , r , g  , b

                pixels.setPixelColor(42, lred, lgreen,lblue); //LED# , r , g  , b
                pixels.setPixelColor(43, lred, lgreen,lblue); //LED# , r , g  , b
        }

        if (segment_c == 7) { // 7
                pixels.setPixelColor(30, 0, 0,0); //LED# , r , g  , b
                pixels.setPixelColor(31, 0, 0,0); //LED# , r , g  , b

                pixels.setPixelColor(32, lred, lgreen,lblue); //LED# , r , g  , b
                pixels.setPixelColor(33, lred, lgreen,lblue); //LED# , r , g  , b

                pixels.setPixelColor(34, lred, lgreen,lblue); //LED# , r , g  , b
                pixels.setPixelColor(35, lred, lgreen,lblue); //LED# , r , g  , b

                pixels.setPixelColor(36, 0, 0,0); //LED# , r , g  , b
                pixels.setPixelColor(37, 0, 0,0); //LED# , r , g  , b

                pixels.setPixelColor(38, 0, 0,0); //LED# , r , g  , b
                pixels.setPixelColor(39, 0, 0,0); //LED# , r , g  , b

                pixels.setPixelColor(40, 0, 0,0); //LED# , r , g  , b
                pixels.setPixelColor(41, 0, 0,0); //LED# , r , g  , b

                pixels.setPixelColor(42, lred, lgreen,lblue); //LED# , r , g  , b
                pixels.setPixelColor(43, lred, lgreen,lblue); //LED# , r , g  , b
        }

        if (segment_c == 8) { // 8
                pixels.setPixelColor(30, lred, lgreen,lblue); //LED# , r , g  , b
                pixels.setPixelColor(31, lred, lgreen,lblue); //LED# , r , g  , b

                pixels.setPixelColor(32, lred, lgreen,lblue); //LED# , r , g  , b
                pixels.setPixelColor(33, lred, lgreen,lblue); //LED# , r , g  , b

                pixels.setPixelColor(34, lred, lgreen,lblue); //LED# , r , g  , b
                pixels.setPixelColor(35, lred, lgreen,lblue); //LED# , r , g  , b

                pixels.setPixelColor(36, lred, lgreen,lblue); //LED# , r , g  , b
                pixels.setPixelColor(37, lred, lgreen,lblue); //LED# , r , g  , b

                pixels.setPixelColor(38, lred, lgreen,lblue); //LED# , r , g  , b
                pixels.setPixelColor(39, lred, lgreen,lblue); //LED# , r , g  , b

                pixels.setPixelColor(40, lred, lgreen,lblue); //LED# , r , g  , b
                pixels.setPixelColor(41, lred, lgreen,lblue); //LED# , r , g  , b

                pixels.setPixelColor(42, lred, lgreen,lblue); //LED# , r , g  , b
                pixels.setPixelColor(43, lred, lgreen,lblue); //LED# , r , g  , b
        }

        if (segment_c == 9) { // 9
                pixels.setPixelColor(30, lred, lgreen,lblue); //LED# , r , g  , b
                pixels.setPixelColor(31, lred, lgreen,lblue); //LED# , r , g  , b

                pixels.setPixelColor(32, lred, lgreen,lblue); //LED# , r , g  , b
                pixels.setPixelColor(33, lred, lgreen,lblue); //LED# , r , g  , b

                pixels.setPixelColor(34, lred, lgreen,lblue); //LED# , r , g  , b
                pixels.setPixelColor(35, lred, lgreen,lblue); //LED# , r , g  , b

                pixels.setPixelColor(36, lred, lgreen,lblue); //LED# , r , g  , b
                pixels.setPixelColor(37, lred, lgreen,lblue); //LED# , r , g  , b

                pixels.setPixelColor(38, 0, 0,0); //LED# , r , g  , b
                pixels.setPixelColor(39, 0, 0,0); //LED# , r , g  , b

                pixels.setPixelColor(40, lred, lgreen,lblue); //LED# , r , g  , b
                pixels.setPixelColor(41, lred, lgreen,lblue); //LED# , r , g  , b

                pixels.setPixelColor(42, lred, lgreen,lblue); //LED# , r , g  , b
                pixels.setPixelColor(43, lred, lgreen,lblue); //LED# , r , g  , b
        }

        if (segment_c == 10) { // 1
                pixels.setPixelColor(30, 0, 0,0); //LED# , r , g  , b
                pixels.setPixelColor(31, 0, 0,0); //LED# , r , g  , b

                pixels.setPixelColor(32, 0, 0,0); //LED# , r , g  , b
                pixels.setPixelColor(33, 0, 0,0); //LED# , r , g  , b

                pixels.setPixelColor(34, 0, 0,0); //LED# , r , g  , b
                pixels.setPixelColor(35, 0, 0,0); //LED# , r , g  , b

                pixels.setPixelColor(36, 0, 0,0); //LED# , r , g  , b
                pixels.setPixelColor(37, 0, 0,0); //LED# , r , g  , b

                pixels.setPixelColor(38, 0, 0,0); //LED# , r , g  , b
                pixels.setPixelColor(39, 0, 0,0); //LED# , r , g  , b

                pixels.setPixelColor(40, 0, 0,0); //LED# , r , g  , b
                pixels.setPixelColor(41, 0, 0,0); //LED# , r , g  , b

                pixels.setPixelColor(42, 0, 0,0); //LED# , r , g  , b
                pixels.setPixelColor(43, 0, 0,0); //LED# , r , g  , b
        }

        if (segment_c == 11) { // 11 znak stopnia
                pixels.setPixelColor(30, lred, lgreen,lblue); //LED# , r , g  , b
                pixels.setPixelColor(31, lred, lgreen,lblue); //LED# , r , g  , b

                pixels.setPixelColor(32,lred, lgreen,lblue); //LED# , r , g  , b
                pixels.setPixelColor(33, lred, lgreen,lblue); //LED# , r , g  , b

                pixels.setPixelColor(34, lred, lgreen,lblue); //LED# , r , g  , b
                pixels.setPixelColor(35, lred, lgreen,lblue); //LED# , r , g  , b

                pixels.setPixelColor(36, lred, lgreen,lblue); //LED# , r , g  , b
                pixels.setPixelColor(37, lred, lgreen,lblue); //LED# , r , g  , b

                pixels.setPixelColor(38, 0, 0,0); //LED# , r , g  , b
                pixels.setPixelColor(39, 0, 0,0); //LED# , r , g  , b

                pixels.setPixelColor(40, 0, 0,0); //LED# , r , g  , b
                pixels.setPixelColor(41, 0, 0,0); //LED# , r , g  , b

                pixels.setPixelColor(42, 0, 0,0); //LED# , r , g  , b
                pixels.setPixelColor(43, 0, 0,0); //LED# , r , g  , b
        }

        if (segment_c == 12) { // 11 znak stopnia
                pixels.setPixelColor(30,  0, 0,0);//LED# , r , g  , b
                pixels.setPixelColor(31,  0, 0,0);//LED# , r , g  , b

                pixels.setPixelColor(32, 0, 0,0); //LED# , r , g  , b
                pixels.setPixelColor(33,  0, 0,0);//LED# , r , g  , b

                pixels.setPixelColor(34,  0, 0,0);//LED# , r , g  , b
                pixels.setPixelColor(35,  0, 0,0);//LED# , r , g  , b

                pixels.setPixelColor(36, lred, lgreen,lblue); //LED# , r , g  , b
                pixels.setPixelColor(37, lred, lgreen,lblue); //LED# , r , g  , b

                pixels.setPixelColor(38, 0, 0,0); //LED# , r , g  , b
                pixels.setPixelColor(39, 0, 0,0); //LED# , r , g  , b

                pixels.setPixelColor(40, 0, 0,0); //LED# , r , g  , b
                pixels.setPixelColor(41, 0, 0,0); //LED# , r , g  , b

                pixels.setPixelColor(42, 0, 0,0); //LED# , r , g  , b
                pixels.setPixelColor(43, 0, 0,0); //LED# , r , g  , b
        }

//segment d

        if (segment_d == 0) { // 0
                pixels.setPixelColor(44, lred, lgreen,lblue); //LED# , r , g  , b
                pixels.setPixelColor(45, lred, lgreen,lblue); //LED# , r , g  , b

                pixels.setPixelColor(46, lred, lgreen,lblue); //LED# , r , g  , b
                pixels.setPixelColor(47, lred, lgreen,lblue); //LED# , r , g  , b

                pixels.setPixelColor(48, lred, lgreen,lblue); //LED# , r , g  , b
                pixels.setPixelColor(49, lred, lgreen,lblue); //LED# , r , g  , b

                pixels.setPixelColor(50, 0, 0,0); //LED# , r , g  , b
                pixels.setPixelColor(51, 0, 0,0); //LED# , r , g  , b

                pixels.setPixelColor(52, lred, lgreen,lblue); //LED# , r , g  , b
                pixels.setPixelColor(53, lred, lgreen,lblue); //LED# , r , g  , b

                pixels.setPixelColor(54, lred, lgreen,lblue); //LED# , r , g  , b
                pixels.setPixelColor(55, lred, lgreen,lblue); //LED# , r , g  , b

                pixels.setPixelColor(56, lred, lgreen,lblue); //LED# , r , g  , b
                pixels.setPixelColor(57, lred, lgreen,lblue); //LED# , r (57,, g  , b
        }

        if (segment_d == 1) { // 1
                pixels.setPixelColor(44, 0, 0,0); //LED# , r , g  , b
                pixels.setPixelColor(45, 0, 0,0); //LED# , r , g  , b

                pixels.setPixelColor(46, 0, 0,0); //LED# , r , g  , b
                pixels.setPixelColor(47, 0, 0,0); //LED# , r , g  , b

                pixels.setPixelColor(48, lred, lgreen,lblue); //LED# , r , g  , b
                pixels.setPixelColor(49, lred, lgreen,lblue); //LED# , r , g  , b

                pixels.setPixelColor(50, 0, 0,0); //LED# , r , g  , b
                pixels.setPixelColor(51, 0, 0,0); //LED# , r , g  , b

                pixels.setPixelColor(52, 0, 0,0); //LED# , r , g  , b
                pixels.setPixelColor(53, 0, 0,0); //LED# , r , g  , b

                pixels.setPixelColor(54, 0, 0,0); //LED# , r , g  , b
                pixels.setPixelColor(55, 0, 0,0); //LED# , r , g  , b

                pixels.setPixelColor(56, lred, lgreen,lblue); //LED# , r , g  , b
                pixels.setPixelColor(57, lred, lgreen,lblue); //LED# , r , g  , b
        }

        if (segment_d == 2) { // 2
                pixels.setPixelColor(44, 0, 0,0); //LED# , r , g  , b
                pixels.setPixelColor(45, 0, 0,0); //LED# , r , g  , b

                pixels.setPixelColor(46, lred, lgreen,lblue); //LED# , r , g  , b
                pixels.setPixelColor(47, lred, lgreen,lblue); //LED# , r , g  , b

                pixels.setPixelColor(48, lred, lgreen,lblue); //LED# , r , g  , b
                pixels.setPixelColor(49, lred, lgreen,lblue); //LED# , r , g  , b

                pixels.setPixelColor(50, lred, lgreen,lblue); //LED# , r , g  , b
                pixels.setPixelColor(51, lred, lgreen,lblue); //LED# , r , g  , b

                pixels.setPixelColor(52, lred, lgreen,lblue); //LED# , r , g  , b
                pixels.setPixelColor(53, lred, lgreen,lblue); //LED# , r , g  , b

                pixels.setPixelColor(54, lred, lgreen,lblue); //LED# , r , g  , b
                pixels.setPixelColor(55, lred, lgreen,lblue); //LED# , r , g  , b

                pixels.setPixelColor(56, 0, 0,0); //LED# , r , g  , b
                pixels.setPixelColor(57, 0, 0,0); //LED# , r , g  , b
        }

        if (segment_d == 3) { // 3
                pixels.setPixelColor(44, 0, 0,0); //LED# , r , g  , b
                pixels.setPixelColor(45, 0, 0,0); //LED# , r , g  , b

                pixels.setPixelColor(46, lred, lgreen,lblue); //LED# , r , g  , b
                pixels.setPixelColor(47, lred, lgreen,lblue); //LED# , r , g  , b

                pixels.setPixelColor(48, lred, lgreen,lblue); //LED# , r , g  , b
                pixels.setPixelColor(49, lred, lgreen,lblue); //LED# , r , g  , b

                pixels.setPixelColor(50, lred, lgreen,lblue); //LED# , r , g  , b
                pixels.setPixelColor(51, lred, lgreen,lblue); //LED# , r , g  , b

                pixels.setPixelColor(52, 0, 0,0); //LED# , r , g  , b
                pixels.setPixelColor(53, 0, 0,0); //LED# , r , g  , b

                pixels.setPixelColor(54, lred, lgreen,lblue); //LED# , r , g  , b
                pixels.setPixelColor(55, lred, lgreen,lblue); //LED# , r , g  , b

                pixels.setPixelColor(56, lred, lgreen,lblue); //LED# , r , g  , b
                pixels.setPixelColor(57, lred, lgreen,lblue); //LED# , r , g  , b
        }

        if (segment_d == 4) { // 4
                pixels.setPixelColor(44, lred, lgreen,lblue); //LED# , r , g  , b
                pixels.setPixelColor(45, lred, lgreen,lblue); //LED# , r , g  , b

                pixels.setPixelColor(46, 0, 0,0); //LED# , r , g  , b
                pixels.setPixelColor(47, 0, 0,0); //LED# , r , g  , b

                pixels.setPixelColor(48, lred, lgreen,lblue); //LED# , r , g  , b
                pixels.setPixelColor(49, lred, lgreen,lblue); //LED# , r , g  , b

                pixels.setPixelColor(50, lred, lgreen,lblue); //LED# , r , g  , b
                pixels.setPixelColor(51, lred, lgreen,lblue); //LED# , r , g  , b

                pixels.setPixelColor(52, 0, 0,0); //LED# , r , g  , b
                pixels.setPixelColor(53, 0, 0,0); //LED# , r , g  , b

                pixels.setPixelColor(54,  0, 0,0);//LED# , r , g  , b
                pixels.setPixelColor(55,  0, 0,0);//LED# , r , g  , b

                pixels.setPixelColor(56, lred, lgreen,lblue); //LED# , r , g  , b
                pixels.setPixelColor(57, lred, lgreen,lblue); //LED# , r , g  , b
        }

        if (segment_d == 5) { // 5
                pixels.setPixelColor(44, lred, lgreen,lblue); //LED# , r , g  , b
                pixels.setPixelColor(45, lred, lgreen,lblue); //LED# , r , g  , b

                pixels.setPixelColor(46, lred, lgreen,lblue); //LED# , r , g  , b
                pixels.setPixelColor(47, lred, lgreen,lblue); //LED# , r , g  , b

                pixels.setPixelColor(48, 0, 0,0); //LED# , r , g  , b
                pixels.setPixelColor(49, 0, 0,0); //LED# , r , g  , b

                pixels.setPixelColor(50, lred, lgreen,lblue); //LED# , r , g  , b
                pixels.setPixelColor(51, lred, lgreen,lblue); //LED# , r , g  , b

                pixels.setPixelColor(52, 0, 0,0); //LED# , r , g  , b
                pixels.setPixelColor(53, 0, 0,0); //LED# , r , g  , b

                pixels.setPixelColor(54,  lred, lgreen,lblue);//LED# , r , g  , b
                pixels.setPixelColor(55,  lred, lgreen,lblue);//LED# , r , g  , b

                pixels.setPixelColor(56, lred, lgreen,lblue); //LED# , r , g  , b
                pixels.setPixelColor(57, lred, lgreen,lblue); //LED# , r , g  , b
        }

        if (segment_d == 6) { // 6
                pixels.setPixelColor(44, lred, lgreen,lblue); //LED# , r , g  , b
                pixels.setPixelColor(45, lred, lgreen,lblue); //LED# , r , g  , b

                pixels.setPixelColor(46, lred, lgreen,lblue); //LED# , r , g  , b
                pixels.setPixelColor(47, lred, lgreen,lblue); //LED# , r , g  , b

                pixels.setPixelColor(48, 0, 0,0); //LED# , r , g  , b
                pixels.setPixelColor(49, 0, 0,0); //LED# , r , g  , b

                pixels.setPixelColor(50, lred, lgreen,lblue); //LED# , r , g  , b
                pixels.setPixelColor(51, lred, lgreen,lblue); //LED# , r , g  , b

                pixels.setPixelColor(52, lred, lgreen,lblue); //LED# , r , g  , b
                pixels.setPixelColor(53, lred, lgreen,lblue); //LED# , r , g  , b

                pixels.setPixelColor(54, lred, lgreen,lblue); //LED# , r , g  , b
                pixels.setPixelColor(55, lred, lgreen,lblue); //LED# , r , g  , b

                pixels.setPixelColor(56, lred, lgreen,lblue); //LED# , r , g  , b
                pixels.setPixelColor(57, lred, lgreen,lblue); //LED# , r , g  , b
        }

        if (segment_d == 7) { // 7
                pixels.setPixelColor(44, 0, 0,0); //LED# , r , g  , b
                pixels.setPixelColor(45, 0, 0,0); //LED# , r , g  , b

                pixels.setPixelColor(46, lred, lgreen,lblue); //LED# , r , g  , b
                pixels.setPixelColor(47, lred, lgreen,lblue); //LED# , r , g  , b

                pixels.setPixelColor(48, lred, lgreen,lblue); //LED# , r , g  , b
                pixels.setPixelColor(49, lred, lgreen,lblue); //LED# , r , g  , b

                pixels.setPixelColor(50, 0, 0,0); //LED# , r , g  , b
                pixels.setPixelColor(51, 0, 0,0); //LED# , r , g  , b

                pixels.setPixelColor(52, 0, 0,0); //LED# , r , g  , b
                pixels.setPixelColor(53, 0, 0,0); //LED# , r , g  , b

                pixels.setPixelColor(54, 0, 0,0); //LED# , r , g  , b
                pixels.setPixelColor(55, 0, 0,0); //LED# , r , g  , b

                pixels.setPixelColor(56, lred, lgreen,lblue); //LED# , r , g  , b
                pixels.setPixelColor(57, lred, lgreen,lblue); //LED# , r , g  , b
        }

        if (segment_d == 8) { // 8
                pixels.setPixelColor(44, lred, lgreen,lblue); //LED# , r , g  , b
                pixels.setPixelColor(45, lred, lgreen,lblue); //LED# , r , g  , b

                pixels.setPixelColor(46, lred, lgreen,lblue); //LED# , r , g  , b
                pixels.setPixelColor(47, lred, lgreen,lblue); //LED# , r , g  , b

                pixels.setPixelColor(48, lred, lgreen,lblue); //LED# , r , g  , b
                pixels.setPixelColor(49, lred, lgreen,lblue); //LED# , r , g  , b

                pixels.setPixelColor(50, lred, lgreen,lblue); //LED# , r , g  , b
                pixels.setPixelColor(51, lred, lgreen,lblue); //LED# , r , g  , b

                pixels.setPixelColor(52, lred, lgreen,lblue); //LED# , r , g  , b
                pixels.setPixelColor(53, lred, lgreen,lblue); //LED# , r , g  , b

                pixels.setPixelColor(54, lred, lgreen,lblue); //LED# , r , g  , b
                pixels.setPixelColor(55, lred, lgreen,lblue); //LED# , r , g  , b

                pixels.setPixelColor(56, lred, lgreen,lblue); //LED# , r , g  , b
                pixels.setPixelColor(57, lred, lgreen,lblue); //LED# , r , g  , b
        }

        if (segment_d == 9) { // 9
                pixels.setPixelColor(44, lred, lgreen,lblue); //LED# , r , g  , b
                pixels.setPixelColor(45, lred, lgreen,lblue); //LED# , r , g  , b

                pixels.setPixelColor(46, lred, lgreen,lblue); //LED# , r , g  , b
                pixels.setPixelColor(47, lred, lgreen,lblue); //LED# , r , g  , b

                pixels.setPixelColor(48, lred, lgreen,lblue); //LED# , r , g  , b
                pixels.setPixelColor(49, lred, lgreen,lblue); //LED# , r , g  , b

                pixels.setPixelColor(50, lred, lgreen,lblue); //LED# , r , g  , b
                pixels.setPixelColor(51, lred, lgreen,lblue); //LED# , r , g  , b

                pixels.setPixelColor(52, 0, 0,0); //LED# , r , g  , b
                pixels.setPixelColor(53, 0, 0,0); //LED# , r , g  , b

                pixels.setPixelColor(54, lred, lgreen,lblue); //LED# , r , g  , b
                pixels.setPixelColor(55, lred, lgreen,lblue); //LED# , r , g  , b

                pixels.setPixelColor(56, lred, lgreen,lblue); //LED# , r , g  , b
                pixels.setPixelColor(57, lred, lgreen,lblue); //LED# , r , g  , b
        }


        if (segment_d == 10) { // 1
                pixels.setPixelColor(44, 0, 0,0); //LED# , r , g  , b
                pixels.setPixelColor(45, 0, 0,0); //LED# , r , g  , b

                pixels.setPixelColor(46, 0, 0,0); //LED# , r , g  , b
                pixels.setPixelColor(47, 0, 0,0); //LED# , r , g  , b

                pixels.setPixelColor(48, 0, 0,0); //LED# , r , g  , b
                pixels.setPixelColor(49, 0, 0,0); //LED# , r , g  , b

                pixels.setPixelColor(50, 0, 0,0); //LED# , r , g  , b
                pixels.setPixelColor(51, 0, 0,0); //LED# , r , g  , b

                pixels.setPixelColor(52, 0, 0,0); //LED# , r , g  , b
                pixels.setPixelColor(53, 0, 0,0); //LED# , r , g  , b

                pixels.setPixelColor(54, 0, 0,0); //LED# , r , g  , b
                pixels.setPixelColor(55, 0, 0,0); //LED# , r , g  , b

                pixels.setPixelColor(56, 0, 0,0); //LED# , r , g  , b
                pixels.setPixelColor(57, 0, 0,0); //LED# , r , g  , b
        }

        if (segment_d == 11) { // 1
                pixels.setPixelColor(44, lred, lgreen,lblue); //LED# , r , g  , b
                pixels.setPixelColor(45, lred, lgreen,lblue); //LED# , r , g  , b

                pixels.setPixelColor(46, lred, lgreen,lblue); //LED# , r , g  , b
                pixels.setPixelColor(47, lred, lgreen,lblue); //LED# , r , g  , b

                pixels.setPixelColor(48,  0, 0,0);//LED# , r , g  , b
                pixels.setPixelColor(49,  0, 0,0);//LED# , r , g  , b

                pixels.setPixelColor(50, 0, 0,0); //LED# , r , g  , b
                pixels.setPixelColor(51, 0, 0,0); //LED# , r , g  , b

                pixels.setPixelColor(52, lred, lgreen,lblue); //LED# , r , g  , b
                pixels.setPixelColor(53, lred, lgreen,lblue); //LED# , r , g  , b

                pixels.setPixelColor(54, lred, lgreen,lblue); //LED# , r , g  , b
                pixels.setPixelColor(55, lred, lgreen,lblue); //LED# , r , g  , b

                pixels.setPixelColor(56, 0, 0,0); //LED# , r , g  , b
                pixels.setPixelColor(57, 0, 0,0); //LED# , r , g  , b
        }

        pixels.show(); //wyslanie do lancucha
        delay(1000);
//last line of void_loop
}
