#include <Arduino.h>
#include <Adafruit_NeoPixel.h>
#include <Wire.h>
#include <DS3231.h>
#include <NTPClient.h>
#include <ESP8266WiFi.h>
#include <WiFiUdp.h>
#include <OneWire.h>
#include <DallasTemperature.h>
#include <ESP8266Ping.h>

const char *ssid     =  "POLREMACO";   //"KLIMA";
const char *password =  "01239456789"; //"Klima503767238";

const long utcOffsetInSeconds = 3600;

const int TnumReadings = 10;
int Treadings[TnumReadings];      // the readings from temp sensor
int Tindex = 0;                   //index of current reading
int Ttotal = 0;                   // the running total
int TAverage = 0;                 // the average
// GPIO where the DS18B20 is connected to
const int oneWireBus = 14; //D5
// Setup a oneWire instance to communicate with any OneWire devices
OneWire oneWire(oneWireBus);
// Pass our oneWire reference to Dallas Temperature sensor
DallasTemperature sensors(&oneWire);





// Define NTP Client to get time
WiFiUDP ntpUDP;
//Atomowy zegar cezowy 5071A Instytutu Łączności w Warszawie
NTPClient timeClient(ntpUDP, "194.146.251.100", utcOffsetInSeconds);
const IPAddress remote_ip(194,146,251,100);

#define PIN D3
#define NUMPIXELS 58
Adafruit_NeoPixel pixels = Adafruit_NeoPixel(NUMPIXELS, PIN, NEO_GRB + NEO_KHZ800);
#define DELAYVAL 500

DS3231 zegar;
RTCDateTime dt;
int segment_a,segment_b,segment_c,segment_d;
int lred = 0;
int lgreen = 0;
int lblue = 0;
int zmienna_test = 0;
int ntp_minuta;
int ntp_godzina;
int ntp_sekunda;
int godzina;
int minuta;
int sekunda;
int temperatura_wew;
int temperatura_zew;
int tryb;
int przewijanie;
int tik;
bool przepisz_czas;
bool przepisz_czas_blokada;
int czas_kolor ;
int ip_a;
int ip_b;
int ip_c;
int ip_d;
int step_ip;
bool setup_clock;
int brak_wifi;
int brak_ntp;
bool blokada_ntp;
bool tylko_raz;



void setup()

{
        Serial.begin(9600);
        pixels.begin(); // Inicjalizacja biblioteki
        pixels.clear(); //czyszczenie lancucha
        Serial.print("kupa ");
        //wlaczenie WiFi
        WiFi.begin(ssid, password);
          while ( WiFi.status() != WL_CONNECTED and brak_wifi < 30) {
            delay ( 500 );
            Serial.print ( "." );
            pixels.setPixelColor(36, 100, 0,0); //LED# , r , g  , b
            pixels.setPixelColor(37, 100, 0,0); //LED# , r , g  , b
            pixels.setPixelColor(20, 100, 0,0); //LED# , r , g  , b
            pixels.setPixelColor(21, 100, 0,0); //LED# , r , g  , b
            pixels.show(); //wyslanie do lancucha
            brak_wifi = brak_wifi + 1;
          }

          Serial.println("IP address: ");
          Serial.println(WiFi.localIP());   //You can get IP address assigned to ESP
          ip_a = int() + WiFi.localIP()[0];
          ip_b = int() + WiFi.localIP()[1];
          ip_c = int() + WiFi.localIP()[2];
          ip_d = int() + WiFi.localIP()[3];
          if(ip_a == 0 and ip_b == 0 and ip_c == 0 and ip_d == 0){
          blokada_ntp = true;
          }

          //wlaczenie klienta npt
          timeClient.begin();
          // Start the DS18B20 sensor
          sensors.begin();
//setup i2c
Wire.begin(5, 4); //SDA, SCL

zegar.begin();

// Ustawiany date i godzine kompilacji szkicu
//zegar.setDateTime(__DATE__, __TIME__);


}//setup koniec
int timeSinceLastRead = 0;




//--------------------------------------Main Loop--------------------------------------//

void loop()
{


//pobranie czasu po NTP
 if (przepisz_czas == false and blokada_ntp == false ) {
   //sprawdzenie dostepnosci sieci i serwera ntp
   if(Ping.ping(remote_ip)) {
     brak_ntp = false;
   } else {
     Serial.println("brak ntp!");
     blokada_ntp = true;
     brak_ntp = true;
   }
   if (brak_ntp == false){
 timeClient.update();
 // Ustawiamy date (Year, Month, Day, Hour, Minute, Second)
  ntp_godzina = timeClient.getHours();
  ntp_minuta = timeClient.getMinutes();
  ntp_sekunda = timeClient.getSeconds();
  zegar.setDateTime(2020, 1, 1, ntp_godzina, ntp_minuta, ntp_sekunda);
 }
 przepisz_czas = true;
 }

 if((sekunda == 10 and minuta == 00) or (sekunda == 10 and minuta == 59)){
   if (blokada_ntp == true and brak_ntp == true ){
     //sprawdzenie dostepnosci sieci i serwera ntp
     if(Ping.ping(remote_ip)) {
       brak_ntp = false;
       blokada_ntp = false;
     } else {
       Serial.println("brak ntp!");
       blokada_ntp = true;
       brak_ntp = true;
     }
   }
   przepisz_czas = false;
  }


 //srednia temperatura
sensors.requestTemperatures();
Ttotal = Ttotal - Treadings[Tindex];             // subtract the last TEMP reading:
Treadings[Tindex] = sensors.getTempCByIndex(0);                       // read TEMP value:
Ttotal= Ttotal + Treadings[Tindex];             // add the TEMP reading to the total:
Tindex = Tindex + 1;                            // advance to the next position in the array:
if (Tindex >= TnumReadings)                    // if we're at the end of the array...
    Tindex = 0;
TAverage = Ttotal / TnumReadings;              // calculate the configTime(gmtOffset_sec, daylightOffset_sec, ntpServer);average


Serial.print("NTP Clock: ");
Serial.print(ntp_godzina);   Serial.print(":");
Serial.print(ntp_minuta); Serial.print(":");
Serial.print(ntp_sekunda); Serial.println("");
                        Serial.print("Temperatura DS3231: ");
                        Serial.print(zegar.readTemperature());
                        Serial.println(" ºC");
                        Serial.print("Temperatura DS18B20: ");
                        Serial.print(TAverage);
                        Serial.println(" ºC");




        //delay(500);

// Odczytujemy i wyswietlamy czas
dt = zegar.getDateTime();

  Serial.print("RTC Clock: ");
  Serial.print(dt.year);   Serial.print("-");
  Serial.print(dt.month);  Serial.print("-");
  Serial.print(dt.day);    Serial.print(" ");
  Serial.print(dt.hour);   Serial.print(":");
  Serial.print(dt.minute); Serial.print(":");
  Serial.print(dt.second); Serial.println("");

if (setup_clock == false){
  step_ip = step_ip + 1;
  if(step_ip >= 12){
    step_ip = 12;
    setup_clock = true;
  }
  lred = 0; lgreen = 100; lblue=100;
  if (step_ip == 1 or step_ip == 2 or step_ip == 3){
    segment_a = ip_a / 100;
    segment_b = ip_a % 100 / 10;
    segment_c = ip_a * 100 % 1000 / 100;
    segment_d = 10;
  }
  if (step_ip == 4 or step_ip == 5 or step_ip == 6){
    segment_a = ip_b / 100;
    segment_b = ip_b % 100 / 10;
    segment_c = ip_b * 100 % 1000 / 100;
    segment_d = 10;
  }
  if (step_ip == 7 or step_ip == 8 or step_ip == 9){
    segment_a = ip_c / 100;
    segment_b = ip_c % 100 / 10;
    segment_c = ip_c * 100 % 1000 / 100;
    segment_d = 10;
  }
  if (step_ip == 10 or step_ip == 11 or step_ip == 12){
    segment_a = ip_d / 100;
    segment_b = ip_d % 100 / 10;
    segment_c = ip_d * 100 % 1000 / 100;
    segment_d = 10;
  }

}


if(setup_clock == true){

        przewijanie = przewijanie + 1;

        if (przewijanie == 30) {
                przewijanie = 0;
        }

        if (przewijanie <=5  ) {
                tryb = 2;
        }
        if (przewijanie == 5) {
                tryb = 1;
        }
        if (przewijanie == 10) {
                tryb = 0;
        }

        if (temperatura_zew <= -100 and tryb == 2){
          tryb = 0;
        }




//jakis tam licznik - do testow
        zmienna_test = zmienna_test + 1;
        if (zmienna_test == 60) {
                zmienna_test = 0;
        }

godzina = dt.hour;
minuta = dt.minute;
sekunda = dt.second;

//kolor w zaleznosci od czasu
if (godzina >= 6 and minuta >=1 and godzina <= 14){
czas_kolor = 1;
}
if (godzina >=14 and minuta >=1 and godzina <= 18){
czas_kolor = 2;
}
if ((godzina >= 18 and minuta >=1) or godzina < 6){
czas_kolor = 3;
}


//tryb wyswietlania - zegar

        if (tryb == 0 and czas_kolor == 1) {//zegar
                lred = 0; lgreen = 50; lblue=0;
                segment_a = godzina / 10;
                segment_b = godzina % 10;
                segment_c = minuta / 10;
                segment_d = minuta % 10;
                tik = tik + 1;
                if (tik > 1) {
                        tik = 0;
                }
                if (tik == 0) {
                        //rozdzielnik
                        pixels.setPixelColor(28, 0, 0,0); //LED# , r , g  , b
                        pixels.setPixelColor(29, 0, 0,0); //LED# , r , g  , b
                }
                if (tik == 1) {
                        //rozdzielnik
                        pixels.setPixelColor(28, 100, 0,0); //LED# , r , g  , b
                        pixels.setPixelColor(29, 100, 0,0); //LED# , r , g  , b
                }
        }//zegar koniec


        if (tryb == 0 and czas_kolor == 2) {//zegar
                lred = 100; lgreen = 0; lblue=0;
                segment_a = godzina / 10;
                segment_b = godzina % 10;
                segment_c = minuta / 10;
                segment_d = minuta % 10;
                tik = tik + 1;
                if (tik > 1) {
                        tik = 0;
                }
                if (tik == 0) {
                        //rozdzielnik
                        pixels.setPixelColor(28, 0, 0,0); //LED# , r , g  , b
                        pixels.setPixelColor(29, 0, 0,0); //LED# , r , g  , b
                }
                if (tik == 1) {
                        //rozdzielnik
                        pixels.setPixelColor(28, 000, 0, 200); //LED# , r , g  , b
                        pixels.setPixelColor(29, 000, 0, 200); //LED# , r , g  , b
                }
        }//zegar koniec


        if (tryb == 0 and czas_kolor == 3) {//zegar
                lred = 0; lgreen = 0; lblue=100;
                segment_a = godzina / 10;
                segment_b = godzina % 10;
                segment_c = minuta / 10;
                segment_d = minuta % 10;
                tik = tik + 1;
                if (tik > 1) {
                        tik = 0;
                }
                if (tik == 0) {
                        //rozdzielnik
                        pixels.setPixelColor(28, 0, 0,0); //LED# , r , g  , b
                        pixels.setPixelColor(29, 0, 0,0); //LED# , r , g  , b
                }
                if (tik == 1) {
                        //rozdzielnik
                        pixels.setPixelColor(28, 0, 200,0); //LED# , r , g  , b
                        pixels.setPixelColor(29, 0, 200,0); //LED# , r , g  , b
                }
        }//zegar koniec

//tryb wyswietlania - temperatura wewneczna
        temperatura_wew = zegar.readTemperature() - 1;
        if (tryb == 1 and tylko_raz == false) {//temperatura
                lred = 50; lgreen = 50; lblue=0;
                segment_a = temperatura_wew / 10;
                segment_b = temperatura_wew % 10;
                segment_c = 11;
                segment_d = 11;

                //rozdzielnik
                pixels.setPixelColor(28, 0, 0,0); //LED# , r , g  , b
                pixels.setPixelColor(29, 0, 0,0); //LED# , r , g  , b
                tylko_raz = true;
        }//temperatura koniec



//tryb wyswietlania - temperatura zewneczna
        temperatura_zew = TAverage;
        if (tryb == 2) {//temperatura_zew
                lred = 50; lgreen = 50; lblue= 50;
                if (temperatura_zew <= 0) {
                        if (temperatura_zew < 0) {
                                if (temperatura_zew <= 0 and temperatura_zew  >= -9) {
                                        segment_a = 11;
                                        segment_b = temperatura_zew * -1;
                                        segment_c = 11;
                                        segment_d = 11;
                                }
                                if (temperatura_zew < -9) {
                                        segment_a = 10;
                                        segment_b = 11;
                                        segment_c =  (temperatura_zew / 10) * -1;
                                        segment_d =  (temperatura_zew % 10) * -1;
                                }
                        }
                }
                if (temperatura_zew == 0 ) {
                        segment_a = 10;
                        segment_b = 0;
                        segment_c = 11;
                        segment_d = 11;
                }
                if (temperatura_zew > 0 and temperatura_zew < 10 ) {
                        segment_a = 10;
                        segment_b = temperatura_zew;
                        segment_c = 11;
                        segment_d = 11;
                }
                if (temperatura_zew > 9 ) {
                        segment_a = temperatura_zew / 10;
                        segment_b = temperatura_zew % 10;
                        segment_c = 11;
                        segment_d = 11;
                }
                //rozdzielnik
                pixels.setPixelColor(28, 0, 0,0); //LED# , r , g  , b
                pixels.setPixelColor(29, 0, 0,0); //LED# , r , g  , b

        }//temperatura koniec

} //setup_clock


        // segment A
        if (segment_a == 0) { // 0
                pixels.setPixelColor(0, lred, lgreen,lblue); //LED# , r , g  , b
                pixels.setPixelColor(1, lred, lgreen,lblue); //LED# , r , g  , b

                pixels.setPixelColor(2, lred, lgreen,lblue); //LED# , r , g  , b
                pixels.setPixelColor(3, lred, lgreen,lblue); //LED# , r , g  , b

                pixels.setPixelColor(4, lred, lgreen,lblue); //LED# , r , g  , b
                pixels.setPixelColor(5, lred, lgreen,lblue); //LED# , r , g  , b

                pixels.setPixelColor(6, 0, 0,0); //LED# , r , g  , b
                pixels.setPixelColor(7, 0, 0,0); //LED# , r , g  , b

                pixels.setPixelColor(8, lred, lgreen,lblue); //LED# , r , g  , b
                pixels.setPixelColor(9, lred, lgreen,lblue); //LED# , r , g  , b

                pixels.setPixelColor(10, lred, lgreen,lblue); //LED# , r , g  , b
                pixels.setPixelColor(11, lred, lgreen,lblue); //LED# , r , g  , b

                pixels.setPixelColor(12, lred, lgreen,lblue); //LED# , r , g  , b
                pixels.setPixelColor(13, lred, lgreen,lblue); //LED# , r , g  , b
        }

        if (segment_a == 1) { // 1
                pixels.setPixelColor(0, 0, 0,0); //LED# , r , g  , b
                pixels.setPixelColor(1, 0, 0,0); //LED# , r , g  , b

                pixels.setPixelColor(2, 0, 0,0); //LED# , r , g  , b
                pixels.setPixelColor(3, 0, 0,0); //LED# , r , g  , b

                pixels.setPixelColor(4, lred, lgreen,lblue); //LED# , r , g  , b
                pixels.setPixelColor(5, lred, lgreen,lblue); //LED# , r , g  , b

                pixels.setPixelColor(6, 0, 0,0); //LED# , r , g  , b
                pixels.setPixelColor(7, 0, 0,0); //LED# , r , g  , b

                pixels.setPixelColor(8, 0, 0,0); //LED# , r , g  , b
                pixels.setPixelColor(9, 0, 0,0); //LED# , r , g  , b

                pixels.setPixelColor(10, 0, 0,0); //LED# , r , g  , b
                pixels.setPixelColor(11, 0, 0,0); //LED# , r , g  , b

                pixels.setPixelColor(12, lred, lgreen,lblue); //LED# , r , g  , b
                pixels.setPixelColor(13, lred, lgreen,lblue); //LED# , r , g  , b
        }

        if (segment_a == 2) { // 2
                pixels.setPixelColor(0, 0, 0,0); //LED# , r , g  , b
                pixels.setPixelColor(1, 0, 0,0); //LED# , r , g  , b

                pixels.setPixelColor(2, lred, lgreen,lblue); //LED# , r , g  , b
                pixels.setPixelColor(3, lred, lgreen,lblue); //LED# , r , g  , b

                pixels.setPixelColor(4, lred, lgreen,lblue); //LED# , r , g  , b
                pixels.setPixelColor(5, lred, lgreen,lblue); //LED# , r , g  , b

                pixels.setPixelColor(6, lred, lgreen,lblue); //LED# , r , g  , b
                pixels.setPixelColor(7, lred, lgreen,lblue); //LED# , r , g  , b

                pixels.setPixelColor(8, lred, lgreen,lblue); //LED# , r , g  , b
                pixels.setPixelColor(9, lred, lgreen,lblue); //LED# , r , g  , b

                pixels.setPixelColor(10, lred, lgreen,lblue); //LED# , r , g  , b
                pixels.setPixelColor(11, lred, lgreen,lblue); //LED# , r , g  , b

                pixels.setPixelColor(12, 0, 0,0); //LED# , r , g  , b
                pixels.setPixelColor(13, 0, 0,0); //LED# , r , g  , b
        }

        if (segment_a == 3) { // 3
                pixels.setPixelColor(0, 0, 0,0); //LED# , r , g  , b
                pixels.setPixelColor(1, 0, 0,0); //LED# , r , g  , b

                pixels.setPixelColor(2, lred, lgreen,lblue); //LED# , r , g  , b
                pixels.setPixelColor(3, lred, lgreen,lblue); //LED# , r , g  , b

                pixels.setPixelColor(4, lred, lgreen,lblue); //LED# , r , g  , b
                pixels.setPixelColor(5, lred, lgreen,lblue); //LED# , r , g  , b

                pixels.setPixelColor(6, lred, lgreen,lblue); //LED# , r , g  , b
                pixels.setPixelColor(7, lred, lgreen,lblue); //LED# , r , g  , b

                pixels.setPixelColor(8, 0, 0,0); //LED# , r , g  , b
                pixels.setPixelColor(9, 0, 0,0); //LED# , r , g  , b

                pixels.setPixelColor(10, lred, lgreen,lblue); //LED# , r , g  , b
                pixels.setPixelColor(11, lred, lgreen,lblue); //LED# , r , g  , b

                pixels.setPixelColor(12, lred, lgreen,lblue); //LED# , r , g  , b
                pixels.setPixelColor(13, lred, lgreen,lblue); //LED# , r , g  , b
        }

        if (segment_a == 4) { // 4
                pixels.setPixelColor(0, lred, lgreen,lblue); //LED# , r , g  , b
                pixels.setPixelColor(1, lred, lgreen,lblue); //LED# , r , g  , b

                pixels.setPixelColor(2, 0, 0,0); //LED# , r , g  , b
                pixels.setPixelColor(3, 0, 0,0); //LED# , r , g  , b

                pixels.setPixelColor(4, lred, lgreen,lblue); //LED# , r , g  , b
                pixels.setPixelColor(5, lred, lgreen,lblue); //LED# , r , g  , b

                pixels.setPixelColor(6, lred, lgreen,lblue); //LED# , r , g  , b
                pixels.setPixelColor(7, lred, lgreen,lblue); //LED# , r , g  , b

                pixels.setPixelColor(8, 0, 0,0); //LED# , r , g  , b
                pixels.setPixelColor(9, 0, 0,0); //LED# , r , g  , b

                pixels.setPixelColor(10,  0, 0,0);//LED# , r , g  , b
                pixels.setPixelColor(11,  0, 0,0);//LED# , r , g  , b

                pixels.setPixelColor(12, lred, lgreen,lblue); //LED# , r , g  , b
                pixels.setPixelColor(13, lred, lgreen,lblue); //LED# , r , g  , b
        }

        if (segment_a == 5) { // 5
                pixels.setPixelColor(0, lred, lgreen,lblue); //LED# , r , g  , b
                pixels.setPixelColor(1, lred, lgreen,lblue); //LED# , r , g  , b

                pixels.setPixelColor(2, lred, lgreen,lblue); //LED# , r , g  , b
                pixels.setPixelColor(3, lred, lgreen,lblue); //LED# , r , g  , b

                pixels.setPixelColor(4, 0, 0,0); //LED# , r , g  , b
                pixels.setPixelColor(5, 0, 0,0); //LED# , r , g  , b

                pixels.setPixelColor(6, lred, lgreen,lblue); //LED# , r , g  , b
                pixels.setPixelColor(7, lred, lgreen,lblue); //LED# , r , g  , b

                pixels.setPixelColor(8, 0, 0,0); //LED# , r , g  , b
                pixels.setPixelColor(9, 0, 0,0); //LED# , r , g  , b

                pixels.setPixelColor(10,  lred, lgreen,lblue);//LED# , r , g  , b
                pixels.setPixelColor(11,  lred, lgreen,lblue);//LED# , r , g  , b

                pixels.setPixelColor(12, lred, lgreen,lblue); //LED# , r , g  , b
                pixels.setPixelColor(13, lred, lgreen,lblue); //LED# , r , g  , b
        }

        if (segment_a == 6) { // 6
                pixels.setPixelColor(0, lred, lgreen,lblue); //LED# , r , g  , b
                pixels.setPixelColor(1, lred, lgreen,lblue); //LED# , r , g  , b

                pixels.setPixelColor(2, lred, lgreen,lblue); //LED# , r , g  , b
                pixels.setPixelColor(3, lred, lgreen,lblue); //LED# , r , g  , b

                pixels.setPixelColor(4, 0, 0,0); //LED# , r , g  , b
                pixels.setPixelColor(5, 0, 0,0); //LED# , r , g  , b

                pixels.setPixelColor(6, lred, lgreen,lblue); //LED# , r , g  , b
                pixels.setPixelColor(7, lred, lgreen,lblue); //LED# , r , g  , b

                pixels.setPixelColor(8, lred, lgreen,lblue); //LED# , r , g  , b
                pixels.setPixelColor(9, lred, lgreen,lblue); //LED# , r , g  , b

                pixels.setPixelColor(10, lred, lgreen,lblue); //LED# , r , g  , b
                pixels.setPixelColor(11, lred, lgreen,lblue); //LED# , r , g  , b

                pixels.setPixelColor(12, lred, lgreen,lblue); //LED# , r , g  , b
                pixels.setPixelColor(13, lred, lgreen,lblue); //LED# , r , g  , b
        }

        if (segment_a == 7) { // 7
                pixels.setPixelColor(0, 0, 0,0); //LED# , r , g  , b
                pixels.setPixelColor(1, 0, 0,0); //LED# , r , g  , b

                pixels.setPixelColor(2, lred, lgreen,lblue); //LED# , r , g  , b
                pixels.setPixelColor(3, lred, lgreen,lblue); //LED# , r , g  , b

                pixels.setPixelColor(4, lred, lgreen,lblue); //LED# , r , g  , b
                pixels.setPixelColor(5, lred, lgreen,lblue); //LED# , r , g  , b

                pixels.setPixelColor(6, 0, 0,0); //LED# , r , g  , b
                pixels.setPixelColor(7, 0, 0,0); //LED# , r , g  , b

                pixels.setPixelColor(8, 0, 0,0); //LED# , r , g  , b
                pixels.setPixelColor(9, 0, 0,0); //LED# , r , g  , b

                pixels.setPixelColor(10, 0, 0,0); //LED# , r , g  , b
                pixels.setPixelColor(11, 0, 0,0); //LED# , r , g  , b

                pixels.setPixelColor(12, lred, lgreen,lblue); //LED# , r , g  , b
                pixels.setPixelColor(13, lred, lgreen,lblue); //LED# , r , g  , b
        }

        if (segment_a == 8) { // 8
                pixels.setPixelColor(0, lred, lgreen,lblue); //LED# , r , g  , b
                pixels.setPixelColor(1, lred, lgreen,lblue); //LED# , r , g  , b

                pixels.setPixelColor(2, lred, lgreen,lblue); //LED# , r , g  , b
                pixels.setPixelColor(3, lred, lgreen,lblue); //LED# , r , g  , b

                pixels.setPixelColor(4, lred, lgreen,lblue); //LED# , r , g  , b
                pixels.setPixelColor(5, lred, lgreen,lblue); //LED# , r , g  , b

                pixels.setPixelColor(6, lred, lgreen,lblue); //LED# , r , g  , b
                pixels.setPixelColor(7, lred, lgreen,lblue); //LED# , r , g  , b

                pixels.setPixelColor(8, lred, lgreen,lblue); //LED# , r , g  , b
                pixels.setPixelColor(9, lred, lgreen,lblue); //LED# , r , g  , b

                pixels.setPixelColor(10, lred, lgreen,lblue); //LED# , r , g  , b
                pixels.setPixelColor(11, lred, lgreen,lblue); //LED# , r , g  , b

                pixels.setPixelColor(12, lred, lgreen,lblue); //LED# , r , g  , b
                pixels.setPixelColor(13, lred, lgreen,lblue); //LED# , r , g  , b
        }

        if (segment_a == 9) { // 9
                pixels.setPixelColor(0, lred, lgreen,lblue); //LED# , r , g  , b
                pixels.setPixelColor(1, lred, lgreen,lblue); //LED# , r , g  , b

                pixels.setPixelColor(2, lred, lgreen,lblue); //LED# , r , g  , b
                pixels.setPixelColor(3, lred, lgreen,lblue); //LED# , r , g  , b

                pixels.setPixelColor(4, lred, lgreen,lblue); //LED# , r , g  , b
                pixels.setPixelColor(5, lred, lgreen,lblue); //LED# , r , g  , b

                pixels.setPixelColor(6, lred, lgreen,lblue); //LED# , r , g  , b
                pixels.setPixelColor(7, lred, lgreen,lblue); //LED# , r , g  , b

                pixels.setPixelColor(8, 0, 0,0); //LED# , r , g  , b
                pixels.setPixelColor(9, 0, 0,0); //LED# , r , g  , b

                pixels.setPixelColor(10, lred, lgreen,lblue); //LED# , r , g  , b
                pixels.setPixelColor(11, lred, lgreen,lblue); //LED# , r , g  , b

                pixels.setPixelColor(12, lred, lgreen,lblue); //LED# , r , g  , b
                pixels.setPixelColor(13, lred, lgreen,lblue); //LED# , r , g  , b
        }

        if (segment_a == 10) { // 10
                pixels.setPixelColor(0,  0, 0,0);//LED# , r , g  , b
                pixels.setPixelColor(1,  0, 0,0);//LED# , r , g  , b

                pixels.setPixelColor(2,  0, 0,0);//LED# , r , g  , b
                pixels.setPixelColor(3,  0, 0,0);//LED# , r , g  , b

                pixels.setPixelColor(4,  0, 0,0);//LED# , r , g  , b
                pixels.setPixelColor(5,  0, 0,0);//LED# , r , g  , b

                pixels.setPixelColor(6,  0, 0,0);//LED# , r , g  , b
                pixels.setPixelColor(7,  0, 0,0);//LED# , r , g  , b

                pixels.setPixelColor(8, 0, 0,0); //LED# , r , g  , b
                pixels.setPixelColor(9, 0, 0,0); //LED# , r , g  , b

                pixels.setPixelColor(10,  0, 0,0);//LED# , r , g  , b
                pixels.setPixelColor(11,  0, 0,0);//LED# , r , g  , b

                pixels.setPixelColor(12,  0, 0,0);//LED# , r , g  , b
                pixels.setPixelColor(13,  0, 0,0);//LED# , r , g  , b
        }
        if (segment_a == 11) { // 10
                pixels.setPixelColor(0,  0, 0,0);//LED# , r , g  , b
                pixels.setPixelColor(1,  0, 0,0);//LED# , r , g  , b

                pixels.setPixelColor(2,  0, 0,0);//LED# , r , g  , b
                pixels.setPixelColor(3,  0, 0,0);//LED# , r , g  , b

                pixels.setPixelColor(4,  0, 0,0);//LED# , r , g  , b
                pixels.setPixelColor(5,  0, 0,0);//LED# , r , g  , b

                pixels.setPixelColor(6,  0, lgreen - 25,lblue + 25);//LED# , r , g  , b
                pixels.setPixelColor(7,  0, lgreen - 25,lblue + 25);//LED# , r , g  , b

                pixels.setPixelColor(8, 0, 0,0); //LED# , r , g  , b
                pixels.setPixelColor(9, 0, 0,0); //LED# , r , g  , b

                pixels.setPixelColor(10,  0, 0,0);//LED# , r , g  , b
                pixels.setPixelColor(11,  0, 0,0);//LED# , r , g  , b

                pixels.setPixelColor(12,  0, 0,0);//LED# , r , g  , b
                pixels.setPixelColor(13,  0, 0,0);//LED# , r , g  , b
        }

//segment b
        if (segment_b == 0) { // 0
                pixels.setPixelColor(14, lred, lgreen,lblue); //LED# , r , g  , b
                pixels.setPixelColor(15, lred, lgreen,lblue); //LED# , r , g  , b

                pixels.setPixelColor(16, lred, lgreen,lblue); //LED# , r , g  , b
                pixels.setPixelColor(17, lred, lgreen,lblue); //LED# , r , g  , b

                pixels.setPixelColor(18, lred, lgreen,lblue); //LED# , r , g  , b
                pixels.setPixelColor(19, lred, lgreen,lblue); //LED# , r , g  , b

                pixels.setPixelColor(20, 0, 0,0); //LED# , r , g  , b
                pixels.setPixelColor(21, 0, 0,0); //LED# , r , g  , b

                pixels.setPixelColor(22, lred, lgreen,lblue); //LED# , r , g  , b
                pixels.setPixelColor(23, lred, lgreen,lblue); //LED# , r , g  , b

                pixels.setPixelColor(24, lred, lgreen,lblue); //LED# , r , g  , b
                pixels.setPixelColor(25, lred, lgreen,lblue); //LED# , r , g  , b

                pixels.setPixelColor(26, lred, lgreen,lblue); //LED# , r , g  , b
                pixels.setPixelColor(27, lred, lgreen,lblue); //LED# , r (27,, g  , b
        }

        if (segment_b == 1) { // 1
                pixels.setPixelColor(14, 0, 0,0); //LED# , r , g  , b
                pixels.setPixelColor(15, 0, 0,0); //LED# , r , g  , b

                pixels.setPixelColor(16, 0, 0,0); //LED# , r , g  , b
                pixels.setPixelColor(17, 0, 0,0); //LED# , r , g  , b

                pixels.setPixelColor(18, lred, lgreen,lblue); //LED# , r , g  , b
                pixels.setPixelColor(19, lred, lgreen,lblue); //LED# , r , g  , b

                pixels.setPixelColor(20, 0, 0,0); //LED# , r , g  , b
                pixels.setPixelColor(21, 0, 0,0); //LED# , r , g  , b

                pixels.setPixelColor(22, 0, 0,0); //LED# , r , g  , b
                pixels.setPixelColor(23, 0, 0,0); //LED# , r , g  , b

                pixels.setPixelColor(24, 0, 0,0); //LED# , r , g  , b
                pixels.setPixelColor(25, 0, 0,0); //LED# , r , g  , b

                pixels.setPixelColor(26, lred, lgreen,lblue); //LED# , r , g  , b
                pixels.setPixelColor(27, lred, lgreen,lblue); //LED# , r , g  , b
        }

        if (segment_b == 2) { // 2
                pixels.setPixelColor(14, 0, 0,0); //LED# , r , g  , b
                pixels.setPixelColor(15, 0, 0,0); //LED# , r , g  , b

                pixels.setPixelColor(16, lred, lgreen,lblue); //LED# , r , g  , b
                pixels.setPixelColor(17, lred, lgreen,lblue); //LED# , r , g  , b

                pixels.setPixelColor(18, lred, lgreen,lblue); //LED# , r , g  , b
                pixels.setPixelColor(19, lred, lgreen,lblue); //LED# , r , g  , b

                pixels.setPixelColor(20, lred, lgreen,lblue); //LED# , r , g  , b
                pixels.setPixelColor(21, lred, lgreen,lblue); //LED# , r , g  , b

                pixels.setPixelColor(22, lred, lgreen,lblue); //LED# , r , g  , b
                pixels.setPixelColor(23, lred, lgreen,lblue); //LED# , r , g  , b

                pixels.setPixelColor(24, lred, lgreen,lblue); //LED# , r , g  , b
                pixels.setPixelColor(25, lred, lgreen,lblue); //LED# , r , g  , b

                pixels.setPixelColor(26, 0, 0,0); //LED# , r , g  , b
                pixels.setPixelColor(27, 0, 0,0); //LED# , r , g  , b
        }

        if (segment_b == 3) { // 3
                pixels.setPixelColor(14, 0, 0,0); //LED# , r , g  , b
                pixels.setPixelColor(15, 0, 0,0); //LED# , r , g  , b

                pixels.setPixelColor(16, lred, lgreen,lblue); //LED# , r , g  , b
                pixels.setPixelColor(17, lred, lgreen,lblue); //LED# , r , g  , b

                pixels.setPixelColor(18, lred, lgreen,lblue); //LED# , r , g  , b
                pixels.setPixelColor(19, lred, lgreen,lblue); //LED# , r , g  , b

                pixels.setPixelColor(20, lred, lgreen,lblue); //LED# , r , g  , b
                pixels.setPixelColor(21, lred, lgreen,lblue); //LED# , r , g  , b

                pixels.setPixelColor(22, 0, 0,0); //LED# , r , g  , b
                pixels.setPixelColor(23, 0, 0,0); //LED# , r , g  , b

                pixels.setPixelColor(24, lred, lgreen,lblue); //LED# , r , g  , b
                pixels.setPixelColor(25, lred, lgreen,lblue); //LED# , r , g  , b

                pixels.setPixelColor(26, lred, lgreen,lblue); //LED# , r , g  , b
                pixels.setPixelColor(27, lred, lgreen,lblue); //LED# , r , g  , b
        }

        if (segment_b == 4) { // 4
                pixels.setPixelColor(14, lred, lgreen,lblue); //LED# , r , g  , b
                pixels.setPixelColor(15, lred, lgreen,lblue); //LED# , r , g  , b

                pixels.setPixelColor(16, 0, 0,0); //LED# , r , g  , b
                pixels.setPixelColor(17, 0, 0,0); //LED# , r , g  , b

                pixels.setPixelColor(18, lred, lgreen,lblue); //LED# , r , g  , b
                pixels.setPixelColor(19, lred, lgreen,lblue); //LED# , r , g  , b

                pixels.setPixelColor(20, lred, lgreen,lblue); //LED# , r , g  , b
                pixels.setPixelColor(21, lred, lgreen,lblue); //LED# , r , g  , b

                pixels.setPixelColor(22, 0, 0,0); //LED# , r , g  , b
                pixels.setPixelColor(23, 0, 0,0); //LED# , r , g  , b

                pixels.setPixelColor(24,  0, 0,0);//LED# , r , g  , b
                pixels.setPixelColor(25,  0, 0,0);//LED# , r , g  , b

                pixels.setPixelColor(26, lred, lgreen,lblue); //LED# , r , g  , b
                pixels.setPixelColor(27, lred, lgreen,lblue); //LED# , r , g  , b
        }

        if (segment_b == 5) { // 5
                pixels.setPixelColor(14, lred, lgreen,lblue); //LED# , r , g  , b
                pixels.setPixelColor(15, lred, lgreen,lblue); //LED# , r , g  , b

                pixels.setPixelColor(16, lred, lgreen,lblue); //LED# , r , g  , b
                pixels.setPixelColor(17, lred, lgreen,lblue); //LED# , r , g  , b

                pixels.setPixelColor(18, 0, 0,0); //LED# , r , g  , b
                pixels.setPixelColor(19, 0, 0,0); //LED# , r , g  , b

                pixels.setPixelColor(20, lred, lgreen,lblue); //LED# , r , g  , b
                pixels.setPixelColor(21, lred, lgreen,lblue); //LED# , r , g  , b

                pixels.setPixelColor(22, 0, 0,0); //LED# , r , g  , b
                pixels.setPixelColor(23, 0, 0,0); //LED# , r , g  , b

                pixels.setPixelColor(24,  lred, lgreen,lblue);//LED# , r , g  , b
                pixels.setPixelColor(25,  lred, lgreen,lblue);//LED# , r , g  , b

                pixels.setPixelColor(26, lred, lgreen,lblue); //LED# , r , g  , b
                pixels.setPixelColor(27, lred, lgreen,lblue); //LED# , r , g  , b
        }

        if (segment_b == 6) { // 6
                pixels.setPixelColor(14, lred, lgreen,lblue); //LED# , r , g  , b
                pixels.setPixelColor(15, lred, lgreen,lblue); //LED# , r , g  , b

                pixels.setPixelColor(16, lred, lgreen,lblue); //LED# , r , g  , b
                pixels.setPixelColor(17, lred, lgreen,lblue); //LED# , r , g  , b

                pixels.setPixelColor(18, 0, 0,0); //LED# , r , g  , b
                pixels.setPixelColor(19, 0, 0,0); //LED# , r , g  , b

                pixels.setPixelColor(20, lred, lgreen,lblue); //LED# , r , g  , b
                pixels.setPixelColor(21, lred, lgreen,lblue); //LED# , r , g  , b

                pixels.setPixelColor(22, lred, lgreen,lblue); //LED# , r , g  , b
                pixels.setPixelColor(23, lred, lgreen,lblue); //LED# , r , g  , b

                pixels.setPixelColor(24, lred, lgreen,lblue); //LED# , r , g  , b
                pixels.setPixelColor(25, lred, lgreen,lblue); //LED# , r , g  , b

                pixels.setPixelColor(26, lred, lgreen,lblue); //LED# , r , g  , b
                pixels.setPixelColor(27, lred, lgreen,lblue); //LED# , r , g  , b
        }

        if (segment_b == 7) { // 7
                pixels.setPixelColor(14, 0, 0,0); //LED# , r , g  , b
                pixels.setPixelColor(15, 0, 0,0); //LED# , r , g  , b

                pixels.setPixelColor(16, lred, lgreen,lblue); //LED# , r , g  , b
                pixels.setPixelColor(17, lred, lgreen,lblue); //LED# , r , g  , b

                pixels.setPixelColor(18, lred, lgreen,lblue); //LED# , r , g  , b
                pixels.setPixelColor(19, lred, lgreen,lblue); //LED# , r , g  , b

                pixels.setPixelColor(20, 0, 0,0); //LED# , r , g  , b
                pixels.setPixelColor(21, 0, 0,0); //LED# , r , g  , b

                pixels.setPixelColor(22, 0, 0,0); //LED# , r , g  , b
                pixels.setPixelColor(23, 0, 0,0); //LED# , r , g  , b

                pixels.setPixelColor(24, 0, 0,0); //LED# , r , g  , b
                pixels.setPixelColor(25, 0, 0,0); //LED# , r , g  , b

                pixels.setPixelColor(26, lred, lgreen,lblue); //LED# , r , g  , b
                pixels.setPixelColor(27, lred, lgreen,lblue); //LED# , r , g  , b
        }

        if (segment_b == 8) { // 8
                pixels.setPixelColor(14, lred, lgreen,lblue); //LED# , r , g  , b
                pixels.setPixelColor(15, lred, lgreen,lblue); //LED# , r , g  , b

                pixels.setPixelColor(16, lred, lgreen,lblue); //LED# , r , g  , b
                pixels.setPixelColor(17, lred, lgreen,lblue); //LED# , r , g  , b

                pixels.setPixelColor(18, lred, lgreen,lblue); //LED# , r , g  , b
                pixels.setPixelColor(19, lred, lgreen,lblue); //LED# , r , g  , b

                pixels.setPixelColor(20, lred, lgreen,lblue); //LED# , r , g  , b
                pixels.setPixelColor(21, lred, lgreen,lblue); //LED# , r , g  , b

                pixels.setPixelColor(22, lred, lgreen,lblue); //LED# , r , g  , b
                pixels.setPixelColor(23, lred, lgreen,lblue); //LED# , r , g  , b

                pixels.setPixelColor(24, lred, lgreen,lblue); //LED# , r , g  , b
                pixels.setPixelColor(25, lred, lgreen,lblue); //LED# , r , g  , b

                pixels.setPixelColor(26, lred, lgreen,lblue); //LED# , r , g  , b
                pixels.setPixelColor(27, lred, lgreen,lblue); //LED# , r , g  , b
        }

        if (segment_b == 9) { // 9
                pixels.setPixelColor(14, lred, lgreen,lblue); //LED# , r , g  , b
                pixels.setPixelColor(15, lred, lgreen,lblue); //LED# , r , g  , b

                pixels.setPixelColor(16, lred, lgreen,lblue); //LED# , r , g  , b
                pixels.setPixelColor(17, lred, lgreen,lblue); //LED# , r , g  , b

                pixels.setPixelColor(18, lred, lgreen,lblue); //LED# , r , g  , b
                pixels.setPixelColor(19, lred, lgreen,lblue); //LED# , r , g  , b

                pixels.setPixelColor(20, lred, lgreen,lblue); //LED# , r , g  , b
                pixels.setPixelColor(21, lred, lgreen,lblue); //LED# , r , g  , b

                pixels.setPixelColor(22, 0, 0,0); //LED# , r , g  , b
                pixels.setPixelColor(23, 0, 0,0); //LED# , r , g  , b

                pixels.setPixelColor(24, lred, lgreen,lblue); //LED# , r , g  , b
                pixels.setPixelColor(25, lred, lgreen,lblue); //LED# , r , g  , b

                pixels.setPixelColor(26, lred, lgreen,lblue); //LED# , r , g  , b
                pixels.setPixelColor(27, lred, lgreen,lblue); //LED# , r , g  , b
        }

        if (segment_b == 10) { // 1
                pixels.setPixelColor(14, 0, 0,0); //LED# , r , g  , b
                pixels.setPixelColor(15, 0, 0,0); //LED# , r , g  , b

                pixels.setPixelColor(16, 0, 0,0); //LED# , r , g  , b
                pixels.setPixelColor(17, 0, 0,0); //LED# , r , g  , b

                pixels.setPixelColor(18, 0, 0,0); //LED# , r , g  , b
                pixels.setPixelColor(19, 0, 0,0); //LED# , r , g  , b

                pixels.setPixelColor(20, 0, 0,0); //LED# , r , g  , b
                pixels.setPixelColor(21, 0, 0,0); //LED# , r , g  , b

                pixels.setPixelColor(22, 0, 0,0); //LED# , r , g  , b
                pixels.setPixelColor(23, 0, 0,0); //LED# , r , g  , b

                pixels.setPixelColor(24, 0, 0,0); //LED# , r , g  , b
                pixels.setPixelColor(25, 0, 0,0); //LED# , r , g  , b

                pixels.setPixelColor(26, 0, 0,0); //LED# , r , g  , b
                pixels.setPixelColor(27, 0, 0,0); //LED# , r , g  , b
        }

        if (segment_b == 11) { // minus symbol "-"
                pixels.setPixelColor(14, 0, 0,0); //LED# , r , g  , b
                pixels.setPixelColor(15, 0, 0,0); //LED# , r , g  , b

                pixels.setPixelColor(16, 0, 0,0); //LED# , r , g  , b
                pixels.setPixelColor(17, 0, 0,0); //LED# , r , g  , b

                pixels.setPixelColor(18, 0, 0,0); //LED# , r , g  , b
                pixels.setPixelColor(19, 0, 0,0); //LED# , r , g  , b

                pixels.setPixelColor(20, 0, lgreen - 20, lblue + 25); //LED# , r , g  , b
                pixels.setPixelColor(21, 0, lgreen - 20, lblue + 25); //LED# , r , g  , b

                pixels.setPixelColor(22, 0, 0,0); //LED# , r , g  , b
                pixels.setPixelColor(23, 0, 0,0); //LED# , r , g  , b

                pixels.setPixelColor(24, 0, 0,0); //LED# , r , g  , b
                pixels.setPixelColor(25, 0, 0,0); //LED# , r , g  , b

                pixels.setPixelColor(26, 0, 0,0); //LED# , r , g  , b
                pixels.setPixelColor(27, 0, 0,0); //LED# , r , g  , b
        }


//segment c
        if (segment_c == 0) { // 0
                pixels.setPixelColor(30, lred, lgreen,lblue); //LED# , r , g  , b
                pixels.setPixelColor(31, lred, lgreen,lblue); //LED# , r , g  , b

                pixels.setPixelColor(32, lred, lgreen,lblue); //LED# , r , g  , b
                pixels.setPixelColor(33, lred, lgreen,lblue); //LED# , r , g  , b

                pixels.setPixelColor(34, lred, lgreen,lblue); //LED# , r , g  , b
                pixels.setPixelColor(35, lred, lgreen,lblue); //LED# , r , g  , b

                pixels.setPixelColor(36, 0, 0,0); //LED# , r , g  , b
                pixels.setPixelColor(37, 0, 0,0); //LED# , r , g  , b

                pixels.setPixelColor(38, lred, lgreen,lblue); //LED# , r , g  , b
                pixels.setPixelColor(39, lred, lgreen,lblue); //LED# , r , g  , b

                pixels.setPixelColor(40, lred, lgreen,lblue); //LED# , r , g  , b
                pixels.setPixelColor(41, lred, lgreen,lblue); //LED# , r , g  , b

                pixels.setPixelColor(42, lred, lgreen,lblue); //LED# , r , g  , b
                pixels.setPixelColor(43, lred, lgreen,lblue); //LED# , r (43,, g  , b
        }

        if (segment_c == 1) { // 1
                pixels.setPixelColor(30, 0, 0,0); //LED# , r , g  , b
                pixels.setPixelColor(31, 0, 0,0); //LED# , r , g  , b

                pixels.setPixelColor(32, 0, 0,0); //LED# , r , g  , b
                pixels.setPixelColor(33, 0, 0,0); //LED# , r , g  , b

                pixels.setPixelColor(34, lred, lgreen,lblue); //LED# , r , g  , b
                pixels.setPixelColor(35, lred, lgreen,lblue); //LED# , r , g  , b

                pixels.setPixelColor(36, 0, 0,0); //LED# , r , g  , b
                pixels.setPixelColor(37, 0, 0,0); //LED# , r , g  , b

                pixels.setPixelColor(38, 0, 0,0); //LED# , r , g  , b
                pixels.setPixelColor(39, 0, 0,0); //LED# , r , g  , b

                pixels.setPixelColor(40, 0, 0,0); //LED# , r , g  , b
                pixels.setPixelColor(41, 0, 0,0); //LED# , r , g  , b

                pixels.setPixelColor(42, lred, lgreen,lblue); //LED# , r , g  , b
                pixels.setPixelColor(43, lred, lgreen,lblue); //LED# , r , g  , b
        }

        if (segment_c == 2) { // 2
                pixels.setPixelColor(30, 0, 0,0); //LED# , r , g  , b
                pixels.setPixelColor(31, 0, 0,0); //LED# , r , g  , b

                pixels.setPixelColor(32, lred, lgreen,lblue); //LED# , r , g  , b
                pixels.setPixelColor(33, lred, lgreen,lblue); //LED# , r , g  , b

                pixels.setPixelColor(34, lred, lgreen,lblue); //LED# , r , g  , b
                pixels.setPixelColor(35, lred, lgreen,lblue); //LED# , r , g  , b

                pixels.setPixelColor(36, lred, lgreen,lblue); //LED# , r , g  , b
                pixels.setPixelColor(37, lred, lgreen,lblue); //LED# , r , g  , b

                pixels.setPixelColor(38, lred, lgreen,lblue); //LED# , r , g  , b
                pixels.setPixelColor(39, lred, lgreen,lblue); //LED# , r , g  , b

                pixels.setPixelColor(40, lred, lgreen,lblue); //LED# , r , g  , b
                pixels.setPixelColor(41, lred, lgreen,lblue); //LED# , r , g  , b

                pixels.setPixelColor(42, 0, 0,0); //LED# , r , g  , b
                pixels.setPixelColor(43, 0, 0,0); //LED# , r , g  , b
        }

        if (segment_c == 3) { // 3
                pixels.setPixelColor(30, 0, 0,0); //LED# , r , g  , b
                pixels.setPixelColor(31, 0, 0,0); //LED# , r , g  , b

                pixels.setPixelColor(32, lred, lgreen,lblue); //LED# , r , g  , b
                pixels.setPixelColor(33, lred, lgreen,lblue); //LED# , r , g  , b

                pixels.setPixelColor(34, lred, lgreen,lblue); //LED# , r , g  , b
                pixels.setPixelColor(35, lred, lgreen,lblue); //LED# , r , g  , b

                pixels.setPixelColor(36, lred, lgreen,lblue); //LED# , r , g  , b
                pixels.setPixelColor(37, lred, lgreen,lblue); //LED# , r , g  , b

                pixels.setPixelColor(38, 0, 0,0); //LED# , r , g  , b
                pixels.setPixelColor(39, 0, 0,0); //LED# , r , g  , b

                pixels.setPixelColor(40, lred, lgreen,lblue); //LED# , r , g  , b
                pixels.setPixelColor(41, lred, lgreen,lblue); //LED# , r , g  , b

                pixels.setPixelColor(42, lred, lgreen,lblue); //LED# , r , g  , b
                pixels.setPixelColor(43, lred, lgreen,lblue); //LED# , r , g  , b
        }

        if (segment_c == 4) { // 4
                pixels.setPixelColor(30, lred, lgreen,lblue); //LED# , r , g  , b
                pixels.setPixelColor(31, lred, lgreen,lblue); //LED# , r , g  , b

                pixels.setPixelColor(32, 0, 0,0); //LED# , r , g  , b
                pixels.setPixelColor(33, 0, 0,0); //LED# , r , g  , b

                pixels.setPixelColor(34, lred, lgreen,lblue); //LED# , r , g  , b
                pixels.setPixelColor(35, lred, lgreen,lblue); //LED# , r , g  , b

                pixels.setPixelColor(36, lred, lgreen,lblue); //LED# , r , g  , b
                pixels.setPixelColor(37, lred, lgreen,lblue); //LED# , r , g  , b

                pixels.setPixelColor(38, 0, 0,0); //LED# , r , g  , b
                pixels.setPixelColor(39, 0, 0,0); //LED# , r , g  , b

                pixels.setPixelColor(40,  0, 0,0);//LED# , r , g  , b
                pixels.setPixelColor(41,  0, 0,0);//LED# , r , g  , b

                pixels.setPixelColor(42, lred, lgreen,lblue); //LED# , r , g  , b
                pixels.setPixelColor(43, lred, lgreen,lblue); //LED# , r , g  , b
        }

        if (segment_c == 5) { // 5
                pixels.setPixelColor(30, lred, lgreen,lblue); //LED# , r , g  , b
                pixels.setPixelColor(31, lred, lgreen,lblue); //LED# , r , g  , b

                pixels.setPixelColor(32, lred, lgreen,lblue); //LED# , r , g  , b
                pixels.setPixelColor(33, lred, lgreen,lblue); //LED# , r , g  , b

                pixels.setPixelColor(34, 0, 0,0); //LED# , r , g  , b
                pixels.setPixelColor(35, 0, 0,0); //LED# , r , g  , b

                pixels.setPixelColor(36, lred, lgreen,lblue); //LED# , r , g  , b
                pixels.setPixelColor(37, lred, lgreen,lblue); //LED# , r , g  , b

                pixels.setPixelColor(38, 0, 0,0); //LED# , r , g  , b
                pixels.setPixelColor(39, 0, 0,0); //LED# , r , g  , b

                pixels.setPixelColor(40,  lred, lgreen,lblue);//LED# , r , g  , b
                pixels.setPixelColor(41,  lred, lgreen,lblue);//LED# , r , g  , b

                pixels.setPixelColor(42, lred, lgreen,lblue); //LED# , r , g  , b
                pixels.setPixelColor(43, lred, lgreen,lblue); //LED# , r , g  , b
        }

        if (segment_c == 6) { // 6
                pixels.setPixelColor(30, lred, lgreen,lblue); //LED# , r , g  , b
                pixels.setPixelColor(31, lred, lgreen,lblue); //LED# , r , g  , b

                pixels.setPixelColor(32, lred, lgreen,lblue); //LED# , r , g  , b
                pixels.setPixelColor(33, lred, lgreen,lblue); //LED# , r , g  , b

                pixels.setPixelColor(34, 0, 0,0); //LED# , r , g  , b
                pixels.setPixelColor(35, 0, 0,0); //LED# , r , g  , b

                pixels.setPixelColor(36, lred, lgreen,lblue); //LED# , r , g  , b
                pixels.setPixelColor(37, lred, lgreen,lblue); //LED# , r , g  , b

                pixels.setPixelColor(38, lred, lgreen,lblue); //LED# , r , g  , b
                pixels.setPixelColor(39, lred, lgreen,lblue); //LED# , r , g  , b

                pixels.setPixelColor(40, lred, lgreen,lblue); //LED# , r , g  , b
                pixels.setPixelColor(41, lred, lgreen,lblue); //LED# , r , g  , b

                pixels.setPixelColor(42, lred, lgreen,lblue); //LED# , r , g  , b
                pixels.setPixelColor(43, lred, lgreen,lblue); //LED# , r , g  , b
        }

        if (segment_c == 7) { // 7
                pixels.setPixelColor(30, 0, 0,0); //LED# , r , g  , b
                pixels.setPixelColor(31, 0, 0,0); //LED# , r , g  , b

                pixels.setPixelColor(32, lred, lgreen,lblue); //LED# , r , g  , b
                pixels.setPixelColor(33, lred, lgreen,lblue); //LED# , r , g  , b

                pixels.setPixelColor(34, lred, lgreen,lblue); //LED# , r , g  , b
                pixels.setPixelColor(35, lred, lgreen,lblue); //LED# , r , g  , b

                pixels.setPixelColor(36, 0, 0,0); //LED# , r , g  , b
                pixels.setPixelColor(37, 0, 0,0); //LED# , r , g  , b

                pixels.setPixelColor(38, 0, 0,0); //LED# , r , g  , b
                pixels.setPixelColor(39, 0, 0,0); //LED# , r , g  , b

                pixels.setPixelColor(40, 0, 0,0); //LED# , r , g  , b
                pixels.setPixelColor(41, 0, 0,0); //LED# , r , g  , b

                pixels.setPixelColor(42, lred, lgreen,lblue); //LED# , r , g  , b
                pixels.setPixelColor(43, lred, lgreen,lblue); //LED# , r , g  , b
        }

        if (segment_c == 8) { // 8
                pixels.setPixelColor(30, lred, lgreen,lblue); //LED# , r , g  , b
                pixels.setPixelColor(31, lred, lgreen,lblue); //LED# , r , g  , b

                pixels.setPixelColor(32, lred, lgreen,lblue); //LED# , r , g  , b
                pixels.setPixelColor(33, lred, lgreen,lblue); //LED# , r , g  , b

                pixels.setPixelColor(34, lred, lgreen,lblue); //LED# , r , g  , b
                pixels.setPixelColor(35, lred, lgreen,lblue); //LED# , r , g  , b

                pixels.setPixelColor(36, lred, lgreen,lblue); //LED# , r , g  , b
                pixels.setPixelColor(37, lred, lgreen,lblue); //LED# , r , g  , b

                pixels.setPixelColor(38, lred, lgreen,lblue); //LED# , r , g  , b
                pixels.setPixelColor(39, lred, lgreen,lblue); //LED# , r , g  , b

                pixels.setPixelColor(40, lred, lgreen,lblue); //LED# , r , g  , b
                pixels.setPixelColor(41, lred, lgreen,lblue); //LED# , r , g  , b

                pixels.setPixelColor(42, lred, lgreen,lblue); //LED# , r , g  , b
                pixels.setPixelColor(43, lred, lgreen,lblue); //LED# , r , g  , b
        }

        if (segment_c == 9) { // 9
                pixels.setPixelColor(30, lred, lgreen,lblue); //LED# , r , g  , b
                pixels.setPixelColor(31, lred, lgreen,lblue); //LED# , r , g  , b

                pixels.setPixelColor(32, lred, lgreen,lblue); //LED# , r , g  , b
                pixels.setPixelColor(33, lred, lgreen,lblue); //LED# , r , g  , b

                pixels.setPixelColor(34, lred, lgreen,lblue); //LED# , r , g  , b
                pixels.setPixelColor(35, lred, lgreen,lblue); //LED# , r , g  , b

                pixels.setPixelColor(36, lred, lgreen,lblue); //LED# , r , g  , b
                pixels.setPixelColor(37, lred, lgreen,lblue); //LED# , r , g  , b

                pixels.setPixelColor(38, 0, 0,0); //LED# , r , g  , b
                pixels.setPixelColor(39, 0, 0,0); //LED# , r , g  , b

                pixels.setPixelColor(40, lred, lgreen,lblue); //LED# , r , g  , b
                pixels.setPixelColor(41, lred, lgreen,lblue); //LED# , r , g  , b

                pixels.setPixelColor(42, lred, lgreen,lblue); //LED# , r , g  , b
                pixels.setPixelColor(43, lred, lgreen,lblue); //LED# , r , g  , b
        }

        if (segment_c == 10) { // 1
                pixels.setPixelColor(30, 0, 0,0); //LED# , r , g  , b
                pixels.setPixelColor(31, 0, 0,0); //LED# , r , g  , b

                pixels.setPixelColor(32, 0, 0,0); //LED# , r , g  , b
                pixels.setPixelColor(33, 0, 0,0); //LED# , r , g  , b

                pixels.setPixelColor(34, 0, 0,0); //LED# , r , g  , b
                pixels.setPixelColor(35, 0, 0,0); //LED# , r , g  , b

                pixels.setPixelColor(36, 0, 0,0); //LED# , r , g  , b
                pixels.setPixelColor(37, 0, 0,0); //LED# , r , g  , b

                pixels.setPixelColor(38, 0, 0,0); //LED# , r , g  , b
                pixels.setPixelColor(39, 0, 0,0); //LED# , r , g  , b

                pixels.setPixelColor(40, 0, 0,0); //LED# , r , g  , b
                pixels.setPixelColor(41, 0, 0,0); //LED# , r , g  , b

                pixels.setPixelColor(42, 0, 0,0); //LED# , r , g  , b
                pixels.setPixelColor(43, 0, 0,0); //LED# , r , g  , b
        }

        if (segment_c == 11) { // 11 znak stopnia
                pixels.setPixelColor(30, lred, lgreen,lblue); //LED# , r , g  , b
                pixels.setPixelColor(31, lred, lgreen,lblue); //LED# , r , g  , b

                pixels.setPixelColor(32,lred, lgreen,lblue); //LED# , r , g  , b
                pixels.setPixelColor(33, lred, lgreen,lblue); //LED# , r , g  , b

                pixels.setPixelColor(34, lred, lgreen,lblue); //LED# , r , g  , b
                pixels.setPixelColor(35, lred, lgreen,lblue); //LED# , r , g  , b

                pixels.setPixelColor(36, lred, lgreen,lblue); //LED# , r , g  , b
                pixels.setPixelColor(37, lred, lgreen,lblue); //LED# , r , g  , b

                pixels.setPixelColor(38, 0, 0,0); //LED# , r , g  , b
                pixels.setPixelColor(39, 0, 0,0); //LED# , r , g  , b

                pixels.setPixelColor(40, 0, 0,0); //LED# , r , g  , b
                pixels.setPixelColor(41, 0, 0,0); //LED# , r , g  , b

                pixels.setPixelColor(42, 0, 0,0); //LED# , r , g  , b
                pixels.setPixelColor(43, 0, 0,0); //LED# , r , g  , b
        }

        if (segment_c == 12) { // 11 znak stopnia
                pixels.setPixelColor(30,  0, 0,0);//LED# , r , g  , b
                pixels.setPixelColor(31,  0, 0,0);//LED# , r , g  , b

                pixels.setPixelColor(32, 0, 0,0); //LED# , r , g  , b
                pixels.setPixelColor(33,  0, 0,0);//LED# , r , g  , b

                pixels.setPixelColor(34,  0, 0,0);//LED# , r , g  , b
                pixels.setPixelColor(35,  0, 0,0);//LED# , r , g  , b

                pixels.setPixelColor(36, lred, lgreen,lblue); //LED# , r , g  , b
                pixels.setPixelColor(37, lred, lgreen,lblue); //LED# , r , g  , b

                pixels.setPixelColor(38, 0, 0,0); //LED# , r , g  , b
                pixels.setPixelColor(39, 0, 0,0); //LED# , r , g  , b

                pixels.setPixelColor(40, 0, 0,0); //LED# , r , g  , b
                pixels.setPixelColor(41, 0, 0,0); //LED# , r , g  , b

                pixels.setPixelColor(42, 0, 0,0); //LED# , r , g  , b
                pixels.setPixelColor(43, 0, 0,0); //LED# , r , g  , b
        }

//segment d

        if (segment_d == 0) { // 0
                pixels.setPixelColor(44, lred, lgreen,lblue); //LED# , r , g  , b
                pixels.setPixelColor(45, lred, lgreen,lblue); //LED# , r , g  , b

                pixels.setPixelColor(46, lred, lgreen,lblue); //LED# , r , g  , b
                pixels.setPixelColor(47, lred, lgreen,lblue); //LED# , r , g  , b

                pixels.setPixelColor(48, lred, lgreen,lblue); //LED# , r , g  , b
                pixels.setPixelColor(49, lred, lgreen,lblue); //LED# , r , g  , b

                pixels.setPixelColor(50, 0, 0,0); //LED# , r , g  , b
                pixels.setPixelColor(51, 0, 0,0); //LED# , r , g  , b

                pixels.setPixelColor(52, lred, lgreen,lblue); //LED# , r , g  , b
                pixels.setPixelColor(53, lred, lgreen,lblue); //LED# , r , g  , b

                pixels.setPixelColor(54, lred, lgreen,lblue); //LED# , r , g  , b
                pixels.setPixelColor(55, lred, lgreen,lblue); //LED# , r , g  , b

                pixels.setPixelColor(56, lred, lgreen,lblue); //LED# , r , g  , b
                pixels.setPixelColor(57, lred, lgreen,lblue); //LED# , r (57,, g  , b
        }

        if (segment_d == 1) { // 1
                pixels.setPixelColor(44, 0, 0,0); //LED# , r , g  , b
                pixels.setPixelColor(45, 0, 0,0); //LED# , r , g  , b

                pixels.setPixelColor(46, 0, 0,0); //LED# , r , g  , b
                pixels.setPixelColor(47, 0, 0,0); //LED# , r , g  , b

                pixels.setPixelColor(48, lred, lgreen,lblue); //LED# , r , g  , b
                pixels.setPixelColor(49, lred, lgreen,lblue); //LED# , r , g  , b

                pixels.setPixelColor(50, 0, 0,0); //LED# , r , g  , b
                pixels.setPixelColor(51, 0, 0,0); //LED# , r , g  , b

                pixels.setPixelColor(52, 0, 0,0); //LED# , r , g  , b
                pixels.setPixelColor(53, 0, 0,0); //LED# , r , g  , b

                pixels.setPixelColor(54, 0, 0,0); //LED# , r , g  , b
                pixels.setPixelColor(55, 0, 0,0); //LED# , r , g  , b

                pixels.setPixelColor(56, lred, lgreen,lblue); //LED# , r , g  , b
                pixels.setPixelColor(57, lred, lgreen,lblue); //LED# , r , g  , b
        }

        if (segment_d == 2) { // 2
                pixels.setPixelColor(44, 0, 0,0); //LED# , r , g  , b
                pixels.setPixelColor(45, 0, 0,0); //LED# , r , g  , b

                pixels.setPixelColor(46, lred, lgreen,lblue); //LED# , r , g  , b
                pixels.setPixelColor(47, lred, lgreen,lblue); //LED# , r , g  , b

                pixels.setPixelColor(48, lred, lgreen,lblue); //LED# , r , g  , b
                pixels.setPixelColor(49, lred, lgreen,lblue); //LED# , r , g  , b

                pixels.setPixelColor(50, lred, lgreen,lblue); //LED# , r , g  , b
                pixels.setPixelColor(51, lred, lgreen,lblue); //LED# , r , g  , b

                pixels.setPixelColor(52, lred, lgreen,lblue); //LED# , r , g  , b
                pixels.setPixelColor(53, lred, lgreen,lblue); //LED# , r , g  , b

                pixels.setPixelColor(54, lred, lgreen,lblue); //LED# , r , g  , b
                pixels.setPixelColor(55, lred, lgreen,lblue); //LED# , r , g  , b

                pixels.setPixelColor(56, 0, 0,0); //LED# , r , g  , b
                pixels.setPixelColor(57, 0, 0,0); //LED# , r , g  , b
        }

        if (segment_d == 3) { // 3
                pixels.setPixelColor(44, 0, 0,0); //LED# , r , g  , b
                pixels.setPixelColor(45, 0, 0,0); //LED# , r , g  , b

                pixels.setPixelColor(46, lred, lgreen,lblue); //LED# , r , g  , b
                pixels.setPixelColor(47, lred, lgreen,lblue); //LED# , r , g  , b

                pixels.setPixelColor(48, lred, lgreen,lblue); //LED# , r , g  , b
                pixels.setPixelColor(49, lred, lgreen,lblue); //LED# , r , g  , b

                pixels.setPixelColor(50, lred, lgreen,lblue); //LED# , r , g  , b
                pixels.setPixelColor(51, lred, lgreen,lblue); //LED# , r , g  , b

                pixels.setPixelColor(52, 0, 0,0); //LED# , r , g  , b
                pixels.setPixelColor(53, 0, 0,0); //LED# , r , g  , b

                pixels.setPixelColor(54, lred, lgreen,lblue); //LED# , r , g  , b
                pixels.setPixelColor(55, lred, lgreen,lblue); //LED# , r , g  , b

                pixels.setPixelColor(56, lred, lgreen,lblue); //LED# , r , g  , b
                pixels.setPixelColor(57, lred, lgreen,lblue); //LED# , r , g  , b
        }

        if (segment_d == 4) { // 4
                pixels.setPixelColor(44, lred, lgreen,lblue); //LED# , r , g  , b
                pixels.setPixelColor(45, lred, lgreen,lblue); //LED# , r , g  , b

                pixels.setPixelColor(46, 0, 0,0); //LED# , r , g  , b
                pixels.setPixelColor(47, 0, 0,0); //LED# , r , g  , b

                pixels.setPixelColor(48, lred, lgreen,lblue); //LED# , r , g  , b
                pixels.setPixelColor(49, lred, lgreen,lblue); //LED# , r , g  , b

                pixels.setPixelColor(50, lred, lgreen,lblue); //LED# , r , g  , b
                pixels.setPixelColor(51, lred, lgreen,lblue); //LED# , r , g  , b

                pixels.setPixelColor(52, 0, 0,0); //LED# , r , g  , b
                pixels.setPixelColor(53, 0, 0,0); //LED# , r , g  , b

                pixels.setPixelColor(54,  0, 0,0);//LED# , r , g  , b
                pixels.setPixelColor(55,  0, 0,0);//LED# , r , g  , b

                pixels.setPixelColor(56, lred, lgreen,lblue); //LED# , r , g  , b
                pixels.setPixelColor(57, lred, lgreen,lblue); //LED# , r , g  , b
        }

        if (segment_d == 5) { // 5
                pixels.setPixelColor(44, lred, lgreen,lblue); //LED# , r , g  , b
                pixels.setPixelColor(45, lred, lgreen,lblue); //LED# , r , g  , b

                pixels.setPixelColor(46, lred, lgreen,lblue); //LED# , r , g  , b
                pixels.setPixelColor(47, lred, lgreen,lblue); //LED# , r , g  , b

                pixels.setPixelColor(48, 0, 0,0); //LED# , r , g  , b
                pixels.setPixelColor(49, 0, 0,0); //LED# , r , g  , b

                pixels.setPixelColor(50, lred, lgreen,lblue); //LED# , r , g  , b
                pixels.setPixelColor(51, lred, lgreen,lblue); //LED# , r , g  , b

                pixels.setPixelColor(52, 0, 0,0); //LED# , r , g  , b
                pixels.setPixelColor(53, 0, 0,0); //LED# , r , g  , b

                pixels.setPixelColor(54,  lred, lgreen,lblue);//LED# , r , g  , b
                pixels.setPixelColor(55,  lred, lgreen,lblue);//LED# , r , g  , b

                pixels.setPixelColor(56, lred, lgreen,lblue); //LED# , r , g  , b
                pixels.setPixelColor(57, lred, lgreen,lblue); //LED# , r , g  , b
        }

        if (segment_d == 6) { // 6
                pixels.setPixelColor(44, lred, lgreen,lblue); //LED# , r , g  , b
                pixels.setPixelColor(45, lred, lgreen,lblue); //LED# , r , g  , b

                pixels.setPixelColor(46, lred, lgreen,lblue); //LED# , r , g  , b
                pixels.setPixelColor(47, lred, lgreen,lblue); //LED# , r , g  , b

                pixels.setPixelColor(48, 0, 0,0); //LED# , r , g  , b
                pixels.setPixelColor(49, 0, 0,0); //LED# , r , g  , b

                pixels.setPixelColor(50, lred, lgreen,lblue); //LED# , r , g  , b
                pixels.setPixelColor(51, lred, lgreen,lblue); //LED# , r , g  , b

                pixels.setPixelColor(52, lred, lgreen,lblue); //LED# , r , g  , b
                pixels.setPixelColor(53, lred, lgreen,lblue); //LED# , r , g  , b

                pixels.setPixelColor(54, lred, lgreen,lblue); //LED# , r , g  , b
                pixels.setPixelColor(55, lred, lgreen,lblue); //LED# , r , g  , b

                pixels.setPixelColor(56, lred, lgreen,lblue); //LED# , r , g  , b
                pixels.setPixelColor(57, lred, lgreen,lblue); //LED# , r , g  , b
        }

        if (segment_d == 7) { // 7
                pixels.setPixelColor(44, 0, 0,0); //LED# , r , g  , b
                pixels.setPixelColor(45, 0, 0,0); //LED# , r , g  , b

                pixels.setPixelColor(46, lred, lgreen,lblue); //LED# , r , g  , b
                pixels.setPixelColor(47, lred, lgreen,lblue); //LED# , r , g  , b

                pixels.setPixelColor(48, lred, lgreen,lblue); //LED# , r , g  , b
                pixels.setPixelColor(49, lred, lgreen,lblue); //LED# , r , g  , b

                pixels.setPixelColor(50, 0, 0,0); //LED# , r , g  , b
                pixels.setPixelColor(51, 0, 0,0); //LED# , r , g  , b

                pixels.setPixelColor(52, 0, 0,0); //LED# , r , g  , b
                pixels.setPixelColor(53, 0, 0,0); //LED# , r , g  , b

                pixels.setPixelColor(54, 0, 0,0); //LED# , r , g  , b
                pixels.setPixelColor(55, 0, 0,0); //LED# , r , g  , b

                pixels.setPixelColor(56, lred, lgreen,lblue); //LED# , r , g  , b
                pixels.setPixelColor(57, lred, lgreen,lblue); //LED# , r , g  , b
        }

        if (segment_d == 8) { // 8
                pixels.setPixelColor(44, lred, lgreen,lblue); //LED# , r , g  , b
                pixels.setPixelColor(45, lred, lgreen,lblue); //LED# , r , g  , b

                pixels.setPixelColor(46, lred, lgreen,lblue); //LED# , r , g  , b
                pixels.setPixelColor(47, lred, lgreen,lblue); //LED# , r , g  , b

                pixels.setPixelColor(48, lred, lgreen,lblue); //LED# , r , g  , b
                pixels.setPixelColor(49, lred, lgreen,lblue); //LED# , r , g  , b

                pixels.setPixelColor(50, lred, lgreen,lblue); //LED# , r , g  , b
                pixels.setPixelColor(51, lred, lgreen,lblue); //LED# , r , g  , b

                pixels.setPixelColor(52, lred, lgreen,lblue); //LED# , r , g  , b
                pixels.setPixelColor(53, lred, lgreen,lblue); //LED# , r , g  , b

                pixels.setPixelColor(54, lred, lgreen,lblue); //LED# , r , g  , b
                pixels.setPixelColor(55, lred, lgreen,lblue); //LED# , r , g  , b

                pixels.setPixelColor(56, lred, lgreen,lblue); //LED# , r , g  , b
                pixels.setPixelColor(57, lred, lgreen,lblue); //LED# , r , g  , b
        }

        if (segment_d == 9) { // 9
                pixels.setPixelColor(44, lred, lgreen,lblue); //LED# , r , g  , b
                pixels.setPixelColor(45, lred, lgreen,lblue); //LED# , r , g  , b

                pixels.setPixelColor(46, lred, lgreen,lblue); //LED# , r , g  , b
                pixels.setPixelColor(47, lred, lgreen,lblue); //LED# , r , g  , b

                pixels.setPixelColor(48, lred, lgreen,lblue); //LED# , r , g  , b
                pixels.setPixelColor(49, lred, lgreen,lblue); //LED# , r , g  , b

                pixels.setPixelColor(50, lred, lgreen,lblue); //LED# , r , g  , b
                pixels.setPixelColor(51, lred, lgreen,lblue); //LED# , r , g  , b

                pixels.setPixelColor(52, 0, 0,0); //LED# , r , g  , b
                pixels.setPixelColor(53, 0, 0,0); //LED# , r , g  , b

                pixels.setPixelColor(54, lred, lgreen,lblue); //LED# , r , g  , b
                pixels.setPixelColor(55, lred, lgreen,lblue); //LED# , r , g  , b

                pixels.setPixelColor(56, lred, lgreen,lblue); //LED# , r , g  , b
                pixels.setPixelColor(57, lred, lgreen,lblue); //LED# , r , g  , b
        }


        if (segment_d == 10) { // 1
                pixels.setPixelColor(44, 0, 0,0); //LED# , r , g  , b
                pixels.setPixelColor(45, 0, 0,0); //LED# , r , g  , b

                pixels.setPixelColor(46, 0, 0,0); //LED# , r , g  , b
                pixels.setPixelColor(47, 0, 0,0); //LED# , r , g  , b

                pixels.setPixelColor(48, 0, 0,0); //LED# , r , g  , b
                pixels.setPixelColor(49, 0, 0,0); //LED# , r , g  , b

                pixels.setPixelColor(50, 0, 0,0); //LED# , r , g  , b
                pixels.setPixelColor(51, 0, 0,0); //LED# , r , g  , b

                pixels.setPixelColor(52, 0, 0,0); //LED# , r , g  , b
                pixels.setPixelColor(53, 0, 0,0); //LED# , r , g  , b

                pixels.setPixelColor(54, 0, 0,0); //LED# , r , g  , b
                pixels.setPixelColor(55, 0, 0,0); //LED# , r , g  , b

                pixels.setPixelColor(56, 0, 0,0); //LED# , r , g  , b
                pixels.setPixelColor(57, 0, 0,0); //LED# , r , g  , b
        }

        if (segment_d == 11) { // 1
                pixels.setPixelColor(44, lred, lgreen,lblue); //LED# , r , g  , b
                pixels.setPixelColor(45, lred, lgreen,lblue); //LED# , r , g  , b

                pixels.setPixelColor(46, lred, lgreen,lblue); //LED# , r , g  , b
                pixels.setPixelColor(47, lred, lgreen,lblue); //LED# , r , g  , b

                pixels.setPixelColor(48,  0, 0,0);//LED# , r , g  , b
                pixels.setPixelColor(49,  0, 0,0);//LED# , r , g  , b

                pixels.setPixelColor(50, 0, 0,0); //LED# , r , g  , b
                pixels.setPixelColor(51, 0, 0,0); //LED# , r , g  , b

                pixels.setPixelColor(52, lred, lgreen,lblue); //LED# , r , g  , b
                pixels.setPixelColor(53, lred, lgreen,lblue); //LED# , r , g  , b

                pixels.setPixelColor(54, lred, lgreen,lblue); //LED# , r , g  , b
                pixels.setPixelColor(55, lred, lgreen,lblue); //LED# , r , g  , b

                pixels.setPixelColor(56, 0, 0,0); //LED# , r , g  , b
                pixels.setPixelColor(57, 0, 0,0); //LED# , r , g  , b
        }

        pixels.show(); //wyslanie do lancucha
        delay(500);
//last line of void_loop
}
